/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class MixinDebugHud {
    @Shadow
    @Final
    private Minecraft f_94030_;
    @Shadow
    @Final
    private Font f_94031_;
    private List<String> capturedList = null;

    @Redirect(method={"renderLeftText", "renderRightText"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"))
    private int preRenderText(List<String> list) {
        this.capturedList = list;
        return 0;
    }

    @Inject(method={"renderLeftText"}, at={@At(value="RETURN")})
    public void renderLeftText(PoseStack matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, false);
    }

    @Inject(method={"renderRightText"}, at={@At(value="RETURN")})
    public void renderRightText(PoseStack matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, true);
    }

    private void renderCapturedText(PoseStack matrixStack, boolean right) {
        Validate.notNull(this.capturedList, (String)"Failed to capture string list", (Object[])new Object[0]);
        this.renderBackdrop(matrixStack, this.capturedList, right);
        this.renderStrings(matrixStack, this.capturedList, right);
        this.capturedList = null;
    }

    private void renderStrings(PoseStack matrixStack, List<String> list, boolean right) {
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.f_94031_.m_92895_(string);
            float x1 = right ? (float)(this.f_94030_.m_91268_().m_85445_() - 2 - width) : 2.0f;
            float y1 = 2 + height * i;
            this.f_94031_.m_92822_(string, x1, y1, 0xE0E0E0, false, positionMatrix, (MultiBufferSource)immediate, false, 0, 0xF000F0, this.f_94031_.m_92718_());
        }
        immediate.m_109911_();
    }

    private void renderBackdrop(PoseStack matrixStack, List<String> list, boolean right) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        int color = -1873784752;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.f_94031_.m_92895_(string);
            int x = right ? this.f_94030_.m_91268_().m_85445_() - 2 - width : 2;
            int y = 2 + height * i;
            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;
            bufferBuilder.m_85982_(matrix, x1, y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x1, y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

