/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.common.base.Stopwatch;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSOtherEventHandler;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.block.KubeJSBlockEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.entity.KubeJSEntityEventHandler;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.item.KubeJSItemEventHandler;
import dev.latvian.mods.kubejs.level.KubeJSWorldEventHandler;
import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.player.KubeJSPlayerEventHandler;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptsLoadedEvent;
import dev.latvian.mods.kubejs.server.KubeJSServerEventHandler;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.MinecraftRemapper;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.CactusBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeJS {
    public static final String MOD_ID = "kubejs";
    public static final String MOD_NAME = "KubeJS";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"KubeJS");
    public static KubeJS instance;
    private static Path gameDirectory;
    public static KubeJSCommon PROXY;
    public static boolean nextClientHasClientMod;
    public static CreativeModeTab tab;
    public static ScriptManager startupScriptManager;
    public static ScriptManager clientScriptManager;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public KubeJS() throws Throwable {
        instance = this;
        gameDirectory = Platform.getGameFolder().normalize().toAbsolutePath();
        Locale.setDefault(Locale.US);
        if (Files.notExists(KubeJSPaths.README, new LinkOption[0])) {
            UtilsJS.tryIO(() -> Files.writeString(KubeJSPaths.README, (CharSequence)"Find more info on the website: https://kubejs.com/\n\nDirectory information:\n\nassets - Acts as a resource pack, you can put any client resources in here, like textures, models, etc. Example: assets/kubejs/textures/item/test_item.png\ndata - Acts as a datapack, you can put any server resources in here, like loot tables, functions, etc. Example: data/kubejs/loot_tables/blocks/test_block.json\n\nstartup_scripts - Scripts that get loaded once during game startup - Used for adding items and other things that can only happen while the game is loading (Can be reloaded with /kubejs reload_startup_scripts, but it may not work!)\nserver_scripts - Scripts that get loaded every time server resources reload - Used for modifying recipes, tags, loot tables, and handling server events (Can be reloaded with /reload)\nclient_scripts - Scripts that get loaded every time client resources reload - Used for JEI events, tooltips and other client side things (Can be reloaded with F3+T)\n\nconfig - KubeJS config storage. This is also the only directory that scripts can access other than world directory\nexported - Data dumps like texture atlases end up here\n\nYou can find type-specific logs in logs/kubejs/ directory\n".trim(), new OpenOption[0]));
        }
        PROXY = (KubeJSCommon)EnvExecutor.getEnvSpecific(() -> KubeJSClient::new, () -> KubeJSCommon::new);
        PROXY.startThread();
        Stopwatch pluginTimer = Stopwatch.createStarted();
        LOGGER.info("Looking for KubeJS plugins...");
        for (Object mod : Platform.getMods()) {
            try {
                KubeJSPlugins.load((Mod)mod);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LOGGER.info("Done in " + pluginTimer.stop());
        startupScriptManager = new ScriptManager(ScriptType.STARTUP, KubeJSPaths.STARTUP_SCRIPTS, "/data/kubejs/example_startup_script.js");
        clientScriptManager = new ScriptManager(ScriptType.CLIENT, KubeJSPaths.CLIENT_SCRIPTS, "/data/kubejs/example_client_script.js");
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::init);
        if (!CommonProperties.get().serverOnly) {
            tab = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MOD_ID, MOD_ID), () -> new ItemStack((ItemLike)Items.f_42493_));
        }
        startupScriptManager.unload();
        startupScriptManager.loadFromDirectory();
        startupScriptManager.load();
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::initStartup);
        KubeJSOtherEventHandler.init();
        KubeJSWorldEventHandler.init();
        KubeJSPlayerEventHandler.init();
        KubeJSEntityEventHandler.init();
        KubeJSBlockEventHandler.init();
        KubeJSItemEventHandler.init();
        KubeJSServerEventHandler.init();
        KubeJSRecipeEventHandler.init();
        PROXY.init();
        if (CommonProperties.get().disableClassFilter) {
            ConsoleJS.STARTUP.warn("Class filter is disabled!");
        }
        if (CommonProperties.get().printRemappedClasses) {
            ConsoleJS.STARTUP.info("Remapped classes:");
            MinecraftRemapper remapper = RemappingHelper.getMinecraftRemapper();
            for (Map.Entry entry : remapper.classMap.entrySet()) {
                ConsoleJS.STARTUP.info("");
                ConsoleJS.STARTUP.info("- " + (String)entry.getKey() + " => " + entry.getValue());
                if (((MinecraftRemapper.RemappedClass)entry.getValue()).children == null) continue;
                for (Map.Entry child : ((MinecraftRemapper.RemappedClass)entry.getValue()).children.entrySet()) {
                    ConsoleJS.STARTUP.info("  " + (String)child.getKey() + " -> " + (String)child.getValue());
                }
            }
            ConsoleJS.STARTUP.info("");
            ConsoleJS.STARTUP.info(remapper.classMap.size() + " classes");
            Class<CactusBlock> testClass = CactusBlock.class;
            ConsoleJS.STARTUP.info("Test: " + testClass.getName() + " => " + remapper.getMappedClass(testClass));
            for (Field field : CactusBlock.class.getDeclaredFields()) {
                ConsoleJS.STARTUP.info("  " + field.getName() + " -> " + remapper.getMappedField(testClass, field));
            }
            for (Method method : CactusBlock.class.getDeclaredMethods()) {
                StringBuilder sb = new StringBuilder("  ");
                sb.append(method.getName());
                sb.append('(');
                if (method.getParameterCount() > 0) {
                    for (Class<?> param : method.getParameterTypes()) {
                        sb.append(Remapper.getTypeName((String)param.getTypeName()));
                    }
                }
                sb.append(") -> ");
                sb.append(remapper.getMappedMethod(testClass, method));
                ConsoleJS.STARTUP.info(sb);
            }
        }
    }

    public static void loadScripts(ScriptPack pack, Path dir, String path) {
        if (!((String)path).isEmpty() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        String pathPrefix = path;
        UtilsJS.tryIO(() -> Files.walk(dir, 10, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
            String fileName = dir.relativize((Path)file).toString().replace(File.separatorChar, '/');
            if (fileName.endsWith(".js")) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, pathPrefix + fileName));
            }
        }));
    }

    public static String appendModId(String id) {
        return id.indexOf(58) == -1 ? "kubejs:" + id : id;
    }

    public static Path getGameDirectory() {
        return gameDirectory;
    }

    public static Path verifyFilePath(Path path) throws IOException {
        if (!path.normalize().toAbsolutePath().startsWith(gameDirectory)) {
            throw new IOException("You can't access files outside Minecraft directory!");
        }
        return path;
    }

    public void setup() {
        UtilsJS.init();
        KubeJSNet.init();
        new StartupEventJS().post(ScriptType.STARTUP, "init");
    }

    public void loadComplete() {
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::afterInit);
        ((Runnable)ScriptsLoadedEvent.EVENT.invoker()).run();
        new StartupEventJS().post(ScriptType.STARTUP, "postinit");
        UtilsJS.postModificationEvents();
    }

    static {
        nextClientHasClientMod = false;
        tab = CreativeModeTab.f_40753_;
    }
}

