/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class IngredientWithCustomPredicateJS
implements IngredientJS {
    public final UUID uuid;
    public final IngredientJS ingredient;
    public final Predicate<ItemStack> predicate;

    public IngredientWithCustomPredicateJS(@Nullable UUID id, IngredientJS i, Predicate<ItemStack> p) {
        this.uuid = id;
        this.ingredient = i;
        this.predicate = p;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return this.ingredient.test(stack) && this.predicate.test(stack.getItemStack());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return this.ingredient.testVanilla(stack) && this.predicate.test(stack);
    }

    @Override
    public boolean testVanillaItem(Item i) {
        return this.ingredient.testVanillaItem(i);
    }

    @Override
    public JsonElement toJson() {
        if (this.uuid != null) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "kubejs:custom_predicate");
            json.add("ingredient", this.ingredient.toJson());
            json.addProperty("uuid", this.uuid.toString());
            return json;
        }
        return this.ingredient.toJson();
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return this.ingredient.getStacks();
    }

    @Override
    public Set<Item> getVanillaItems() {
        return this.ingredient.getVanillaItems();
    }

    @Override
    public boolean isEmpty() {
        return this.ingredient.isEmpty();
    }

    @Override
    public int getCount() {
        return this.ingredient.getCount();
    }

    @Override
    public ItemStackJS getFirst() {
        return this.ingredient.getFirst();
    }

    @Override
    public Predicate<ItemStack> getVanillaPredicate() {
        return this.ingredient.getVanillaPredicate().and(this.predicate);
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        return this.ingredient.isInvalidRecipeIngredient();
    }

    public String toString() {
        return this.ingredient + " (with custom predicate)";
    }
}

