/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BotanyPotsCropRecipeJS
extends RecipeJS {
    public final List<Integer> minRolls = new ArrayList<Integer>();
    public final List<Integer> maxRolls = new ArrayList<Integer>();

    @Override
    public void create(ListJS args) {
        for (Object o : ListJS.orSelf(args.get(0))) {
            if (o instanceof Map) {
                Map m = (Map)o;
                this.outputItems.add(this.parseResultItem(m.get("item")));
                this.minRolls.add(((Number)m.getOrDefault("minRolls", 1)).intValue());
                this.maxRolls.add(((Number)m.getOrDefault("maxRolls", 1)).intValue());
                continue;
            }
            this.outputItems.add(this.parseResultItem(o));
            this.minRolls.add(1);
            this.maxRolls.add(1);
        }
        this.inputItems.add(this.parseIngredientItem(args.get(1)));
        JsonArray categories = new JsonArray();
        categories.add("grass");
        this.json.add("categories", (JsonElement)categories);
        this.json.addProperty("growthTicks", (Number)1200);
        JsonObject display = new JsonObject();
        display.addProperty("block", ((IngredientJS)this.inputItems.get(0)).getFirst().getId());
        this.json.add("display", (JsonElement)display);
    }

    @Override
    public void deserialize() {
        this.inputItems.add(this.parseIngredientItem(this.json.get("seed")));
        for (JsonElement e : this.json.get("results").getAsJsonArray()) {
            JsonObject o = e.getAsJsonObject();
            ItemStackJS is = this.parseResultItem(o.get("output"));
            if (o.has("chance")) {
                is.setChance(o.get("chance").getAsDouble());
            }
            this.outputItems.add(is);
            this.minRolls.add(o.has("minRolls") ? o.get("minRolls").getAsInt() : 1);
            this.maxRolls.add(o.has("maxRolls") ? o.get("maxRolls").getAsInt() : 1);
        }
    }

    public BotanyPotsCropRecipeJS growthTicks(int t) {
        this.json.addProperty("growthTicks", (Number)t);
        this.save();
        return this;
    }

    public BotanyPotsCropRecipeJS categories(String[] c) {
        JsonArray categories = new JsonArray();
        for (String s : c) {
            categories.add(s);
        }
        this.json.add("categories", (JsonElement)categories);
        this.save();
        return this;
    }

    public BotanyPotsCropRecipeJS displayBlock(String b) {
        JsonObject display = new JsonObject();
        display.addProperty("block", b);
        this.json.add("display", (JsonElement)display);
        this.save();
        return this;
    }

    @Override
    public void serialize() {
        if (this.serializeInputs) {
            this.json.add("seed", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
        if (this.serializeOutputs) {
            JsonArray array = new JsonArray();
            for (int i = 0; i < this.outputItems.size(); ++i) {
                ItemStackJS is = (ItemStackJS)this.outputItems.get(i);
                JsonObject o = new JsonObject();
                o.addProperty("chance", (Number)(is.hasChance() ? is.getChance() : 1.0));
                o.addProperty("minRolls", (Number)this.minRolls.get(i));
                o.addProperty("maxRolls", (Number)this.maxRolls.get(i));
                is.removeChance();
                o.add("output", is.toResultJson());
                array.add((JsonElement)o);
            }
            this.json.add("results", (JsonElement)array);
        }
    }
}

