/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class ScriptFile
implements Comparable<ScriptFile> {
    public final ScriptPack pack;
    public final ScriptFileInfo info;
    public final ScriptSource source;
    private Throwable error;

    public ScriptFile(ScriptPack p, ScriptFileInfo i, ScriptSource s) {
        this.pack = p;
        this.info = i;
        this.source = s;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public boolean load() {
        boolean bl;
        block8: {
            this.error = null;
            InputStream stream = this.source.createStream(this.info);
            try {
                String script = new String(IOUtils.toByteArray((InputStream)new BufferedInputStream(stream)), StandardCharsets.UTF_8);
                this.pack.context.evaluateString(this.pack.scope, script, this.info.location, 1, null);
                bl = true;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    this.error = ex;
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    @Override
    public int compareTo(ScriptFile o) {
        return Integer.compare(o.info.getPriority(), this.info.getPriority());
    }
}

