/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.EventsJS;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.CustomJavaToJsWrappersEvent;
import dev.latvian.mods.kubejs.script.RegistryTypeWrapperFactory;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.RhinoException;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class ScriptManager {
    public final ScriptType type;
    public final Path directory;
    public final String exampleScript;
    public final EventsJS events;
    public final Map<String, ScriptPack> packs;
    private final ClassFilter classFilter;
    public boolean firstLoad;
    private Map<String, Optional<NativeJavaClass>> javaClassCache;

    public ScriptManager(ScriptType t, Path p, String e) {
        this.type = t;
        this.directory = p;
        this.exampleScript = e;
        this.events = new EventsJS(this);
        this.packs = new LinkedHashMap<String, ScriptPack>();
        this.firstLoad = true;
        this.classFilter = KubeJSPlugins.createClassFilter(this.type);
    }

    public void unload() {
        this.events.clear();
        this.packs.clear();
        this.type.errors.clear();
        this.type.warnings.clear();
        this.type.console.resetFile();
        this.javaClassCache = null;
    }

    public void loadFromDirectory() {
        if (Files.notExists(this.directory, new LinkOption[0])) {
            UtilsJS.tryIO(() -> Files.createDirectories(this.directory, new FileAttribute[0]));
            try (InputStream in = KubeJS.class.getResourceAsStream(this.exampleScript);
                 OutputStream out = Files.newOutputStream(this.directory.resolve("script.js"), new OpenOption[0]);){
                out.write(IOUtils.toByteArray((InputStream)in));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ScriptPack pack = new ScriptPack(this, new ScriptPackInfo(this.directory.getFileName().toString(), ""));
        KubeJS.loadScripts(pack, this.directory, "");
        for (ScriptFileInfo fileInfo : pack.info.scripts) {
            ScriptSource.FromPath scriptSource = info -> this.directory.resolve(info.file);
            Throwable error = fileInfo.preload(scriptSource);
            String packMode = fileInfo.getPackMode();
            if (fileInfo.isIgnored() || !packMode.equals("default") && !packMode.equals(CommonProperties.get().packMode)) continue;
            if (error == null) {
                pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                continue;
            }
            KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
        }
        pack.scripts.sort(null);
        this.packs.put(pack.info.namespace, pack);
    }

    public boolean isClassAllowed(String name) {
        return this.classFilter.isAllowed(name);
    }

    public void load() {
        Context context = Context.enterWithNewFactory();
        context.setClassShutter((fullClassName, type) -> type != 2 || this.isClassAllowed(fullClassName));
        context.setRemapper(RemappingHelper.createModRemapper());
        TypeWrappers typeWrappers = context.getTypeWrappers();
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addTypeWrappers(this.type, typeWrappers));
        for (RegistryTypeWrapperFactory<?> registryTypeWrapperFactory : RegistryTypeWrapperFactory.getAll()) {
            try {
                typeWrappers.register(registryTypeWrapperFactory.type, (TypeWrapperFactory)UtilsJS.cast(registryTypeWrapperFactory));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        long startAll = System.currentTimeMillis();
        int i = 0;
        int t = 0;
        for (ScriptPack pack : this.packs.values()) {
            try {
                pack.context = context;
                pack.scope = context.initStandardObjects();
                BindingsEvent bindingsEvent = new BindingsEvent(this, pack.context, pack.scope);
                KubeJSPlugins.forEachPlugin(plugin -> plugin.addBindings(bindingsEvent));
                ((Consumer)BindingsEvent.EVENT.invoker()).accept(bindingsEvent);
                CustomJavaToJsWrappersEvent customJavaToJsWrappersEvent = new CustomJavaToJsWrappersEvent(this, pack.context);
                KubeJSPlugins.forEachPlugin(plugin -> plugin.addCustomJavaToJsWrappers(customJavaToJsWrappersEvent));
                ((Consumer)CustomJavaToJsWrappersEvent.EVENT.invoker()).accept(customJavaToJsWrappersEvent);
                for (ScriptFile file : pack.scripts) {
                    ++t;
                    long start = System.currentTimeMillis();
                    if (file.load()) {
                        ++i;
                        this.type.console.info("Loaded script " + file.info.location + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s");
                        continue;
                    }
                    if (file.getError() == null) continue;
                    if (file.getError() instanceof RhinoException) {
                        this.type.console.error("Error loading KubeJS script: " + file.getError().getMessage());
                        continue;
                    }
                    this.type.console.error("Error loading KubeJS script: " + file.info.location + ": " + file.getError());
                    file.getError().printStackTrace();
                }
            }
            catch (Throwable ex) {
                this.type.console.error("Failed to read script pack " + pack.info.namespace + ": ", ex);
            }
        }
        this.type.console.info("Loaded " + i + "/" + t + " KubeJS " + this.type.name + " scripts in " + (double)(System.currentTimeMillis() - startAll) / 1000.0 + " s");
        Context.exit();
        this.events.postToHandlers("loaded", this.events.handlers("loaded"), new StartupEventJS());
        if (i != t && this.type == ScriptType.STARTUP) {
            throw new RuntimeException("There were startup script syntax errors! See logs/kubejs/startup.txt for more info");
        }
        this.firstLoad = false;
    }

    public NativeJavaClass loadJavaClass(Scriptable scope, Object[] args) {
        Optional<NativeJavaClass> ch;
        String name = RemappingHelper.getMinecraftRemapper().getUnmappedClass(args[0].toString());
        if (name.isEmpty()) {
            throw Context.reportRuntimeError((String)"Class name can't be empty!");
        }
        if (this.javaClassCache == null) {
            this.javaClassCache = new HashMap<String, Optional<NativeJavaClass>>();
        }
        if ((ch = this.javaClassCache.get(name)) == null) {
            this.javaClassCache.put(name, Optional.empty());
            try {
                if (!this.isClassAllowed(name)) {
                    throw Context.reportRuntimeError((String)"Failed to dynamically load class '%s': Class is not allowed by class filter!".formatted(name));
                }
                Class<?> c = Class.forName(name);
                NativeJavaClass njc = new NativeJavaClass(scope, c);
                this.javaClassCache.put(name, Optional.of(njc));
                return njc;
            }
            catch (ClassNotFoundException cnf) {
                throw Context.reportRuntimeError((String)"Failed to dynamically load class '%s': Class could not be found!\n%s".formatted(name, cnf.getMessage()));
            }
        }
        if (ch.isPresent()) {
            return ch.get();
        }
        throw Context.reportRuntimeError((String)"Failed to dynamically load class '%s'!".formatted(name));
    }
}

