/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.world.level.LevelReader;
import org.slf4j.LoggerFactory;

public enum ScriptType {
    STARTUP("startup", "KubeJS Startup", () -> KubeJS.startupScriptManager),
    SERVER("server", "KubeJS Server", () -> ServerScriptManager.instance.scriptManager),
    CLIENT("client", "KubeJS Client", () -> KubeJS.clientScriptManager);

    public final String name;
    public final List<String> errors;
    public final List<String> warnings;
    public final ConsoleJS console;
    public final Supplier<ScriptManager> manager;
    public final ExecutorService executor;

    public static ScriptType of(LevelReader level) {
        return level.m_5776_() ? CLIENT : SERVER;
    }

    private ScriptType(String n2, String cname, Supplier<ScriptManager> m) {
        this.name = n2;
        this.errors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.console = new ConsoleJS(this, LoggerFactory.getLogger((String)cname));
        this.manager = m;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public Path getLogFile() {
        Path dir = Platform.getGameFolder().resolve("logs/kubejs");
        Path file = dir.resolve(this.name + ".txt");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public boolean isServer() {
        return this == SERVER;
    }
}

