/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.Context;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConsoleJS {
    public static ConsoleJS STARTUP;
    public static ConsoleJS SERVER;
    public static ConsoleJS CLIENT;
    private final ScriptType scriptType;
    private final Logger logger;
    private final Path logFile;
    private String group;
    private int lineNumber;
    private boolean muted;
    private boolean debugEnabled;
    private boolean writeToFile;
    private final List<String> writeQueue;

    public ConsoleJS(ScriptType m, Logger log) {
        this.scriptType = m;
        this.logger = log;
        this.logFile = m.getLogFile();
        this.group = "";
        this.lineNumber = 0;
        this.muted = false;
        this.debugEnabled = false;
        this.writeToFile = true;
        this.writeQueue = new ArrayList<String>();
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected boolean shouldPrint() {
        return !this.muted;
    }

    public void setMuted(boolean m) {
        this.muted = m;
    }

    public boolean getMuted() {
        return this.muted;
    }

    public void setDebugEnabled(boolean m) {
        this.debugEnabled = m;
    }

    public boolean getDebugEnabled() {
        return this.debugEnabled;
    }

    public void setWriteToFile(boolean m) {
        this.writeToFile = m;
    }

    public boolean getWriteToFile() {
        return this.writeToFile;
    }

    public void resetFile() {
        this.scriptType.executor.execute(() -> {
            try {
                Files.write(this.logFile, Collections.emptyList(), new OpenOption[0]);
            }
            catch (Exception ex) {
                this.logger.error("Failed to clear the log file: " + ex);
            }
        });
    }

    public void setLineNumber(boolean b) {
        this.lineNumber += b ? 1 : -1;
    }

    private String string(Object object) {
        String s;
        Object o = UtilsJS.wrap(object, JSObjectType.ANY);
        String string = s = o == null || o.getClass().isPrimitive() || o instanceof Boolean || o instanceof String || o instanceof Number || o instanceof WrappedJS ? String.valueOf(o) : o + " [" + o.getClass().getName() + "]";
        if (this.lineNumber <= 0 && this.group.isEmpty()) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        if (this.lineNumber > 0) {
            int[] lineP = new int[]{0};
            String lineS = Context.getSourcePositionFromStack((int[])lineP);
            if (lineP[0] > 0) {
                if (lineS != null) {
                    builder.append(lineS);
                }
                builder.append(':');
                builder.append(lineP[0]);
                builder.append(": ");
            }
        }
        builder.append(this.group);
        builder.append(s);
        return builder.toString();
    }

    private String stringf(Object object, Object ... args) {
        return this.string(String.format(String.valueOf(object), args));
    }

    private void log(Consumer<String> logFunction, String type, Object message) {
        if (this.shouldPrint()) {
            String s = this.string(message);
            logFunction.accept(s);
            this.writeToFile(type, s);
        }
    }

    private void logf(Consumer<String> logFunction, String type, Object message, Object ... args) {
        if (!this.shouldPrint()) {
            String s = this.stringf(message, args);
            logFunction.accept(s);
            this.writeToFile(type, s);
        }
    }

    private void writeToFile(String type, String line) {
        if (!this.writeToFile) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (calendar.get(11) < 10) {
            sb.append('0');
        }
        sb.append(calendar.get(11));
        sb.append(':');
        if (calendar.get(12) < 10) {
            sb.append('0');
        }
        sb.append(calendar.get(12));
        sb.append(':');
        if (calendar.get(13) < 10) {
            sb.append('0');
        }
        sb.append(calendar.get(13));
        sb.append(']');
        sb.append(' ');
        sb.append('[');
        sb.append(type);
        sb.append(']');
        sb.append(' ');
        sb.append(line);
        this.writeQueue.add(sb.toString());
    }

    public synchronized void flush() {
        if (this.writeQueue.isEmpty()) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>(this.writeQueue);
        this.writeQueue.clear();
        this.scriptType.executor.execute(() -> {
            try {
                Files.write(this.logFile, (Iterable<? extends CharSequence>)lines, StandardOpenOption.APPEND);
            }
            catch (Exception ex) {
                this.logger.error("Failed to write to the log file: " + ex);
            }
        });
    }

    public void info(Object message) {
        this.log(arg_0 -> ((Logger)this.logger).info(arg_0), "INFO ", message);
    }

    public void infof(Object message, Object ... args) {
        this.logf(arg_0 -> ((Logger)this.logger).info(arg_0), "INFO ", message, args);
    }

    public void log(Object message) {
        this.info(message);
    }

    public void warn(Object message) {
        this.log(s -> {
            this.logger.warn(s);
            this.scriptType.warnings.add((String)s);
        }, "WARN ", message);
    }

    public void warn(String message, Throwable throwable, @Nullable Pattern skip) {
        if (this.shouldPrint()) {
            String s = throwable.toString();
            if (CommonProperties.get().debugInfo || s.equals("java.lang.NullPointerException")) {
                this.warn(message + ":");
                this.printStackTrace(throwable, skip);
            } else {
                this.warn(message + ": " + s);
            }
        }
    }

    public void warn(String message, Throwable throwable) {
        this.warn(message, throwable, null);
    }

    public void warnf(String message, Object ... args) {
        this.logf(s -> {
            this.logger.warn(s);
            this.scriptType.warnings.add((String)s);
        }, "WARN ", message, args);
    }

    public void error(Object message) {
        this.log(s -> {
            this.logger.error(s);
            this.scriptType.errors.add((String)s);
        }, "ERR  ", message);
    }

    public void error(String message, Throwable throwable, @Nullable Pattern skip) {
        if (this.shouldPrint()) {
            String s = throwable.toString();
            if (CommonProperties.get().debugInfo || s.equals("java.lang.NullPointerException")) {
                this.error(message + ":");
                this.printStackTrace(throwable, skip);
            } else {
                this.error(message + ": " + s);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        this.error(message, throwable, null);
    }

    public void errorf(String message, Object ... args) {
        this.logf(s -> {
            this.logger.error(s);
            this.scriptType.errors.add((String)s);
        }, "ERR ", message, args);
    }

    public boolean shouldPrintDebug() {
        return this.debugEnabled && this.shouldPrint();
    }

    public void debug(Object message) {
        if (this.shouldPrintDebug()) {
            this.log(arg_0 -> ((Logger)this.logger).debug(arg_0), "DEBUG", message);
        }
    }

    public void debugf(String message, Object ... args) {
        if (this.shouldPrintDebug()) {
            this.logf(arg_0 -> ((Logger)this.logger).debug(arg_0), "DEBUG", message, args);
        }
    }

    public void group() {
        this.group = this.group + "  ";
    }

    public void groupEnd() {
        if (this.group.length() >= 2) {
            this.group = this.group.substring(0, this.group.length() - 2);
        }
    }

    public void trace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        this.info("=== Stack Trace ===");
        for (StackTraceElement element : elements) {
            this.info("=\t" + element);
        }
    }

    public int getScriptLine() {
        int[] linep = new int[]{0};
        Context.getSourcePositionFromStack((int[])linep);
        return linep[0];
    }

    public void printClass(String className, boolean tree) {
        this.setLineNumber(true);
        try {
            Class<?> c = Class.forName(className);
            Class<?> sc = c.getSuperclass();
            this.info("=== " + c.getName() + " ===");
            this.info("= Parent class =");
            this.info("> " + (sc == null ? "-" : sc.getName()));
            HashMap<Object, VarFunc> vars = new HashMap<Object, VarFunc>();
            HashMap<String, VarFunc> funcs = new HashMap<String, VarFunc>();
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 0x80) == 0) continue;
                VarFunc f2 = new VarFunc(field.getName(), field.getType());
                f2.flags |= 1;
                if ((field.getModifiers() & 0x10) == 0) {
                    f2.flags |= 2;
                }
                vars.put(f2.name, f2);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if ((((Method)accessibleObject).getModifiers() & 1) == 0 || this.isOverrideMethod((Method)accessibleObject)) continue;
                VarFunc f2 = new VarFunc(((Method)accessibleObject).getName(), ((Method)accessibleObject).getReturnType());
                for (int i = 0; i < ((Method)accessibleObject).getParameterCount(); ++i) {
                    f2.params.add(((Executable)accessibleObject).getParameters()[i].getType());
                }
                if (f2.name.length() >= 4 && f2.name.startsWith("get") && Character.isUpperCase(f2.name.charAt(3)) && f2.params.size() == 0) {
                    String n = Character.toLowerCase(f2.name.charAt(3)) + f2.name.substring(4);
                    VarFunc f0 = (VarFunc)vars.get(n);
                    if (f0 == null) {
                        vars.put(n, new VarFunc(n, f2.type));
                        continue;
                    }
                    if (f0.type.equals(f2.type)) {
                        f0.flags |= 1;
                        continue;
                    }
                }
                funcs.put(f2.name, f2);
            }
            this.info("= Variables and Functions =");
            if (vars.isEmpty() && funcs.isEmpty()) {
                this.info("-");
            } else {
                vars.values().stream().sorted().forEach(f -> this.info("> " + ((f.flags & 2) == 0 ? "val" : "var") + " " + f.name + ": " + this.getSimpleName(f.type)));
                funcs.values().stream().sorted().forEach(f -> this.info("> function " + f.name + "(" + f.params.stream().map(this::getSimpleName).collect(Collectors.joining(", ")) + "): " + this.getSimpleName(f.type)));
            }
            if (tree && sc != null) {
                this.info("");
                this.printClass(sc.getName(), true);
            }
        }
        catch (Throwable ex) {
            this.error("= Error loading class =");
            this.error(ex.toString());
        }
        this.setLineNumber(false);
    }

    public void printClass(String className) {
        this.printClass(className, false);
    }

    private String getSimpleName(Class<?> c) {
        if (c.isPrimitive()) {
            return c.getName();
        }
        String s = c.getName();
        int i = s.lastIndexOf(46);
        s = s.substring(i + 1);
        i = s.lastIndexOf(36);
        s = s.substring(i + 1);
        return s;
    }

    private boolean isOverrideMethod(Method method) throws Throwable {
        return false;
    }

    public void printObject(@Nullable Object o, boolean tree) {
        this.setLineNumber(true);
        if (o == null) {
            this.info("=== null ===");
        } else {
            this.info("=== " + o.getClass().getName() + " ===");
            this.info("= toString() =");
            this.info("> " + o);
            this.info("= hashCode() =");
            this.info("> " + Integer.toHexString(o.hashCode()));
            this.info("");
            this.printClass(o.getClass().getName(), tree);
        }
        this.setLineNumber(false);
    }

    public void printObject(@Nullable Object o) {
        this.printObject(o, false);
    }

    public void printStackTrace(Throwable throwable, @Nullable Pattern skip) {
        throwable.printStackTrace(new StackTracePrintStream(this, skip));
    }

    private static final class VarFunc
    implements Comparable<VarFunc> {
        public final String name;
        public final Class<?> type;
        public final ArrayList<Class<?>> params;
        public int flags;

        public VarFunc(String n, Class<?> t) {
            this.name = n;
            this.type = t;
            this.flags = 0;
            this.params = new ArrayList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarFunc varFunc = (VarFunc)o;
            return Objects.equals(this.name, varFunc.name) && Objects.equals(this.type, varFunc.type) && Objects.equals(this.flags, varFunc.flags) && Objects.equals(this.params, varFunc.params);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.flags, this.params);
        }

        @Override
        public int compareTo(VarFunc o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final ConsoleJS console;
        private boolean first;
        private final Pattern skipString;
        private boolean skip;

        private StackTracePrintStream(ConsoleJS c, @Nullable Pattern ca) {
            super(System.err);
            this.console = c;
            this.first = true;
            this.skipString = ca;
            this.skip = false;
        }

        @Override
        public void println(@Nullable Object x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(@Nullable String x) {
            if (this.skip) {
                return;
            }
            if (this.first && x != null) {
                this.console.scriptType.errors.add(x);
                this.first = false;
            }
            if (x != null && this.skipString != null && this.skipString.matcher(x).find()) {
                this.skip = true;
            } else {
                this.console.log(arg_0 -> ((Logger)this.console.logger).error(arg_0), "ERR  ", x);
            }
        }
    }
}

