/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client;

import com.eerussianguy.firmalife.client.render.BonsaiPlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.DryingMatBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.HangingPlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.LargePlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.MixingBowlBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.OvenBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.QuadPlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.StringBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.TrellisPlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.screen.BeehiveScreen;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.container.FLContainerTypes;
import com.eerussianguy.firmalife.common.entities.FLEntities;
import com.eerussianguy.firmalife.common.entities.FLParticles;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.util.FLMetal;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.particle.GlintParticleProvider;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class FLClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(FLClientEvents::clientSetup);
        bus.addListener(FLClientEvents::registerEntityRenderers);
        bus.addListener(FLClientEvents::onTextureStitch);
        bus.addListener(FLClientEvents::onModelRegister);
        bus.addListener(FLClientEvents::onBlockColors);
        bus.addListener(FLClientEvents::onItemColors);
        bus.addListener(FLClientEvents::registerParticleFactories);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType solid = RenderType.m_110451_();
        RenderType cutout = RenderType.m_110463_();
        RenderType cutoutMipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        Stream.of(FLBlocks.OVEN_TOP, FLBlocks.OVEN_BOTTOM, FLBlocks.OVEN_CHIMNEY, FLBlocks.CURED_OVEN_TOP, FLBlocks.CURED_OVEN_BOTTOM, FLBlocks.CURED_OVEN_CHIMNEY, FLBlocks.QUAD_PLANTER, FLBlocks.LARGE_PLANTER, FLBlocks.HANGING_PLANTER, FLBlocks.BONSAI_PLANTER, FLBlocks.IRON_COMPOSTER, FLBlocks.COMPOST_JAR, FLBlocks.HONEY_JAR, FLBlocks.ROTTEN_COMPOST_JAR, FLBlocks.GUANO_JAR, FLBlocks.CHEDDAR_WHEEL, FLBlocks.RAJYA_METOK_WHEEL, FLBlocks.CHEVRE_WHEEL, FLBlocks.SHOSHA_WHEEL, FLBlocks.FETA_WHEEL, FLBlocks.GOUDA_WHEEL, FLBlocks.SMALL_CHROMITE, FLBlocks.MIXING_BOWL, FLBlocks.BUTTERFLY_GRASS, FLBlocks.BASIL, FLBlocks.BAY_LAUREL, FLBlocks.CUMIN, FLBlocks.CARDAMOM, FLBlocks.CILANTRO, FLBlocks.OREGANO, FLBlocks.PIMENTO, FLBlocks.VANILLA).forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.CHROMITE_ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        FLBlocks.FRUIT_PRESERVES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)translucent));
        FLBlocks.FL_FRUIT_PRESERVES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)translucent));
        FLBlocks.GREENHOUSE_BLOCKS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.BEEHIVE.get()), BeehiveScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.PUMPKIN.get()), KnappingScreen::new);
            TFCItems.FOOD.forEach((food, item) -> {
                if (FLItems.TFC_FRUITS.contains(food)) {
                    FLClientEvents.registerDryProperty((Supplier<Item>)item);
                }
            });
            FLItems.FRUITS.forEach((food, item) -> FLClientEvents.registerDryProperty((Supplier<Item>)item));
        });
    }

    public static void onBlockColors(ColorHandlerEvent.Block event) {
        BlockColors registry = event.getBlockColors();
        BlockColor grassColor = (state, level, pos, tintIndex) -> TFCColors.getGrassColor((BlockPos)pos, (int)tintIndex);
        BlockColor tallGrassColor = (state, level, pos, tintIndex) -> TFCColors.getTallGrassColor((BlockPos)pos, (int)tintIndex);
        registry.m_92589_(tallGrassColor, new Block[]{(Block)FLBlocks.BUTTERFLY_GRASS.get()});
        Stream.of(FLBlocks.BASIL, FLBlocks.BAY_LAUREL, FLBlocks.CARDAMOM, FLBlocks.CILANTRO, FLBlocks.CUMIN, FLBlocks.OREGANO, FLBlocks.PIMENTO, FLBlocks.VANILLA).forEach(reg -> registry.m_92589_(grassColor, new Block[]{(Block)reg.get()}));
    }

    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors registry = event.getItemColors();
        ItemColor grassColor = (stack, tintIndex) -> TFCColors.getGrassColor(null, (int)tintIndex);
        Stream.of(FLBlocks.BUTTERFLY_GRASS).forEach(reg -> registry.m_92689_(grassColor, new ItemLike[]{(ItemLike)reg.get()}));
    }

    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        engine.m_107378_((ParticleType)FLParticles.GROWTH.get(), set -> new GlintParticleProvider(set, ChatFormatting.GREEN));
    }

    private static void registerDryProperty(Supplier<Item> item) {
        ItemProperties.register((Item)item.get(), (ResourceLocation)FLHelpers.identifier("dry"), (stack, a, b, c) -> stack.getCapability(FoodCapability.CAPABILITY).map(cap -> cap.getTraits().contains(FLFoodTraits.DRIED)).orElse(false) != false ? 1.0f : 0.0f);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.OVEN_TOP.get(), ctx -> new OvenBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.DRYING_MAT.get(), ctx -> new DryingMatBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.STRING.get(), ctx -> new StringBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.LARGE_PLANTER.get(), ctx -> new LargePlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.QUAD_PLANTER.get(), ctx -> new QuadPlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.TRELLIS_PLANTER.get(), ctx -> new TrellisPlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.BONSAI_PLANTER.get(), ctx -> new BonsaiPlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.HANGING_PLANTER.get(), ctx -> new HangingPlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.MIXING_BOWL.get(), ctx -> new MixingBowlBlockEntityRenderer());
        event.registerEntityRenderer((EntityType)FLEntities.SEED_BALL.get(), ThrownItemRenderer::new);
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        int i;
        for (String string : new String[]{"green_bean", "maize", "jute", "tomato", "sugarcane"}) {
            for (i = 0; i < 5; ++i) {
                event.addSprite(FLHelpers.identifier("block/crop/" + string + "_" + i));
            }
        }
        for (String string : new String[]{"squash", "banana"}) {
            for (i = 0; i < 5; ++i) {
                event.addSprite(FLHelpers.identifier("block/crop/" + string + "_" + i));
            }
            event.addSprite(FLHelpers.identifier("block/crop/" + string + "_fruit"));
        }
        for (String string : new String[]{"melon", "pumpkin"}) {
            for (i = 0; i < 7; ++i) {
                event.addSprite(FLHelpers.identifier("block/crop/" + string + "_" + i));
            }
            event.addSprite(FLHelpers.identifier("block/crop/" + string + "_fruit"));
        }
        for (FLMetal fLMetal : FLMetal.values()) {
            event.addSprite(fLMetal.getSheet());
        }
    }

    public static void onModelRegister(ModelRegistryEvent event) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)MixingBowlBlockEntityRenderer.SPOON_LOCATION);
    }
}

