/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.client.render.RenderUtils;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class BonsaiPlanterBlockEntityRenderer
implements BlockEntityRenderer<LargePlanterBlockEntity> {
    public void render(LargePlanterBlockEntity planter, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        String baseTex = plant.getTextureLocation();
        String leafTex = "_leaves";
        if (growth >= 1.0f) {
            leafTex = "_fruiting_leaves";
        } else if (!water) {
            leafTex = "_dry_leaves";
        } else if (growth > 0.66f) {
            leafTex = "_flowering_leaves";
        }
        TextureAtlasSprite branch = (TextureAtlasSprite)atlas.apply(new ResourceLocation(baseTex + "_branch"));
        TextureAtlasSprite leaves = (TextureAtlasSprite)atlas.apply(new ResourceLocation(baseTex + leafTex));
        poseStack.m_85836_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        RenderUtils.renderTexturedCuboid(poseStack, buffer, branch, combinedLight, combinedOverlay, 0.4375f, 0.4375f, 0.4375f, 0.5625f, 1.125f, 0.5625f);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, branch, combinedLight, combinedOverlay, 0.4375f, 0.75f, 0.25f, 0.5625f, 0.875f, 0.4375f);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, branch, combinedLight, combinedOverlay, 0.3125f, 0.875f, 0.5f, 0.4375f, 1.0f, 0.75f);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, leaves, combinedLight, combinedOverlay, 0.25f, 0.75f, 0.625f, 0.625f, 1.1875f, 1.0f);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, leaves, combinedLight, combinedOverlay, 0.1875f, 0.6875f, 0.3125f, 0.6875f, 1.3125f, 0.6875f);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, leaves, combinedLight, combinedOverlay, 0.25f, 0.625f, 0.0625f, 0.75f, 1.0625f, 0.4375f);
        poseStack.m_85849_();
    }
}

