/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.MixingBowlBlockEntity;
import com.eerussianguy.firmalife.common.blocks.MixingBowlBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class MixingBowlBlockEntityRenderer
implements BlockEntityRenderer<MixingBowlBlockEntity> {
    public static final ResourceLocation SPOON_LOCATION = FLHelpers.identifier("block/spoon");

    public void render(MixingBowlBlockEntity bowl, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        if (bowl.m_58904_() != null) {
            BlockState state = bowl.m_58904_().m_8055_(bowl.m_58899_());
            if (state.m_60734_() instanceof MixingBowlBlock && ((Boolean)state.m_61143_((Property)MixingBowlBlock.SPOON)).booleanValue()) {
                poseStack.m_85836_();
                Minecraft mc = Minecraft.m_91087_();
                BakedModel baked = mc.m_91304_().getModel(SPOON_LOCATION);
                VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
                int rot = bowl.getRotationTimer();
                if (!bowl.isMixing()) {
                    partialTicks = 0.0f;
                    rot = 120;
                }
                poseStack.m_85837_(0.5, 0.0, 0.5);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)rot - partialTicks) * 4.0f));
                poseStack.m_85837_(-0.5, 0.0, -0.5);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(22.5f));
                poseStack.m_85837_(0.0, (double)0.4f, 0.0);
                mc.m_91289_().m_110937_().renderModel(poseStack.m_85850_(), buffer, null, baked, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            bowl.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(cap -> {
                FluidStack fluid = cap.getFluidInTank(0);
                if (!fluid.isEmpty()) {
                    RenderHelpers.renderFluidFace((PoseStack)poseStack, (FluidStack)fluid, (MultiBufferSource)buffers, (int)RenderHelpers.getFluidColor((FluidStack)fluid), (float)0.1875f, (float)0.1875f, (float)0.8125f, (float)0.8125f, (float)0.3125f, (int)combinedOverlay, (int)combinedLight);
                }
            });
            poseStack.m_85849_();
            poseStack.m_85836_();
            bowl.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> {
                int ordinal = 0;
                ItemRenderer render = Minecraft.m_91087_().m_91291_();
                for (int slot = 0; slot < 5; ++slot) {
                    ItemStack item = cap.getStackInSlot(slot);
                    if (item.m_41619_()) continue;
                    float yOffset = 0.125f;
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.5, 0.003125 + (double)yOffset, 0.5);
                    poseStack.m_85841_(0.3f, 0.3f, 0.3f);
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                    poseStack.m_85837_(0.0, 0.0, (double)(-0.12f * (float)(++ordinal)));
                    render.m_174269_(item, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, buffers, 0);
                    poseStack.m_85849_();
                }
            });
            poseStack.m_85849_();
        }
    }
}

