/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.client.render.RenderUtils;
import com.eerussianguy.firmalife.common.blockentities.TrellisPlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class TrellisPlanterBlockEntityRenderer
implements BlockEntityRenderer<TrellisPlanterBlockEntity> {
    public void render(TrellisPlanterBlockEntity planter, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        String baseTex = plant.getTextureLocation();
        String prefix = "";
        if (growth >= 1.0f) {
            prefix = "fruiting_";
        } else if (!water) {
            prefix = "dry_";
        } else if (growth > 0.66f) {
            prefix = "flowering_";
        }
        String[] splits = baseTex.split("block/berry_bush/", 2);
        ResourceLocation actualTexture = new ResourceLocation(splits[0] + "block/berry_bush/" + prefix + splits[1]);
        poseStack.m_85836_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(actualTexture);
        RenderUtils.renderTexturedCuboid(poseStack, buffer, sprite, combinedLight, combinedOverlay, 0.0f, 0.0f, 0.0f, 1.0f, 1.01f, 1.0f);
        poseStack.m_85849_();
    }
}

