/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.network.FLPackets;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Plantable;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;

public class FLForgeEvents {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(FLForgeEvents::onFireStart);
        bus.addListener(FLForgeEvents::addReloadListeners);
        bus.addListener(FLForgeEvents::onDataPackSync);
        bus.addListener(FLForgeEvents::onAnimalProduce);
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(GreenhouseType.MANAGER);
        event.addListener(Plantable.MANAGER);
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        FLPackets.send(target, GreenhouseType.MANAGER.createSyncPacket());
        FLPackets.send(target, Plantable.MANAGER.createSyncPacket());
    }

    public static void onFireStart(StartFireEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (block == FLBlocks.OVEN_BOTTOM.get() || block == FLBlocks.CURED_OVEN_BOTTOM.get()) {
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get()).ifPresent(oven -> oven.light(state));
            event.setCanceled(true);
        } else if (block instanceof CarvedPumpkinBlock) {
            FLBlocks.CARVED_PUMPKINS.forEach((carve, reg) -> {
                if (block == reg.get()) {
                    level.m_46597_(pos, Helpers.copyProperty((BlockState)((Block)FLBlocks.JACK_O_LANTERNS.get(carve).get()).m_49966_(), (BlockState)state, (Property)HorizontalDirectionalBlock.f_54117_));
                    event.setCanceled(true);
                }
            });
        }
    }

    public static void onAnimalProduce(AnimalProductEvent event) {
        Entity entity = event.getEntity();
        ItemStack product = event.getProduct();
        if (entity.m_6095_() == TFCEntities.YAK.get()) {
            FLForgeEvents.replaceFluid(product, (Fluid)FLFluids.EXTRA_FLUIDS.get((Object)ExtraFluid.YAK_MILK).getSource());
        } else if (entity.m_6095_() == TFCEntities.GOAT.get()) {
            FLForgeEvents.replaceFluid(product, (Fluid)FLFluids.EXTRA_FLUIDS.get((Object)ExtraFluid.GOAT_MILK).getSource());
        }
    }

    private static void replaceFluid(ItemStack bucket, Fluid toFill) {
        bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(cap -> {
            int drained = cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE).getAmount();
            if (drained > 0) {
                cap.fill(new FluidStack(toFill, drained), IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }
}

