/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common;

import com.eerussianguy.firmalife.FirmaLife;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.slf4j.Logger;

public class FLHelpers {
    public static final boolean ASSERTIONS_ENABLED = FLHelpers.detectAssertionsEnabled();
    public static Direction[] NOT_DOWN = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP};

    public static ResourceLocation identifier(String id) {
        return new ResourceLocation("firmalife", id);
    }

    public static void resetCounter(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)blockEntity;
            counter.resetCounter();
        }
    }

    public static <T> JsonElement codecToJson(Codec<T> codec, T instance) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).getOrThrow(false, Util.m_137489_((String)"Error encoding: ", arg_0 -> ((Logger)FirmaLife.LOGGER).error(arg_0)));
    }

    public static Component blockEntityName(String name) {
        return new TranslatableComponent("firmalife.block_entity." + name);
    }

    public static <T extends BlockEntity> void readInventory(Level level, BlockPos pos, Supplier<BlockEntityType<T>> type, BiConsumer<T, IItemHandler> consumer) {
        level.m_141902_(pos, type.get()).ifPresent(be -> be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> consumer.accept((Object)be, (IItemHandler)inv)));
    }

    public static <T extends BlockEntity> InteractionResult consumeInventory(Level level, BlockPos pos, Supplier<BlockEntityType<T>> type, BiFunction<T, IItemHandler, InteractionResult> consumer) {
        return level.m_141902_(pos, type.get()).map(be -> be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> (InteractionResult)consumer.apply((Object)be, (IItemHandler)inv)).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult insertOne(Level level, ItemStack item, int slot, IItemHandler inv, Player player) {
        if (!inv.isItemValid(slot, item)) {
            return InteractionResult.PASS;
        }
        return FLHelpers.completeInsertion(level, item, inv, player, slot);
    }

    public static InteractionResult takeOne(Level level, int slot, IItemHandler inv, Player player) {
        ItemStack stack = inv.extractItem(slot, 1, false);
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult insertOneAny(Level level, ItemStack item, int start, int end, ICapabilityProvider provider, Player player) {
        return provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> FLHelpers.insertOneAny(level, item, start, end, inv, player)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult insertOneAny(Level level, ItemStack item, int start, int end, IItemHandler inv, Player player) {
        for (int i = start; i <= end; ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            return FLHelpers.completeInsertion(level, item, inv, player, i);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult completeInsertion(Level level, ItemStack item, IItemHandler inv, Player player, int slot) {
        ItemStack stack = inv.insertItem(slot, item.m_41620_(1), false);
        if (stack.m_41619_()) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult takeOneAny(Level level, int start, int end, ICapabilityProvider provider, Player player) {
        return provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> FLHelpers.takeOneAny(level, start, end, inv, player)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult takeOneAny(Level level, int start, int end, IItemHandler inv, Player player) {
        for (int i = start; i <= end; ++i) {
            ItemStack stack = inv.extractItem(i, 1, false);
            if (stack.m_41619_()) continue;
            if (!level.f_46443_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Iterable<BlockPos> allPositionsCentered(BlockPos center, int radius, int height) {
        return BlockPos.m_121940_((BlockPos)center.m_142082_(-radius, -height, -radius), (BlockPos)center.m_142082_(radius, height, radius));
    }

    public static TranslatableComponent translateEnum(Enum<?> anEnum) {
        return Helpers.translatable((String)FLHelpers.getEnumTranslationKey(anEnum));
    }

    public static String getEnumTranslationKey(Enum<?> anEnum) {
        return FLHelpers.getEnumTranslationKey(anEnum, anEnum.getDeclaringClass().getSimpleName());
    }

    public static String getEnumTranslationKey(Enum<?> anEnum, String enumName) {
        return String.join((CharSequence)".", "firmalife", "enum", enumName, anEnum.name()).toLowerCase(Locale.ROOT);
    }

    private static boolean detectAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }
}

