/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ClimateStationBlockEntity
extends TFCBlockEntity {
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private boolean isCellar = false;

    public ClimateStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.CLIMATE_STATION.get(), pos, state);
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.isCellar = nbt.m_128471_("cellar");
        long[] array = nbt.m_128467_("positions");
        this.positions.clear();
        this.positions = new HashSet<BlockPos>(array.length);
        for (long pos : array) {
            this.positions.add(BlockPos.m_122022_((long)pos));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("cellar", this.isCellar);
        long[] array = new long[this.positions.size()];
        int i = 0;
        for (BlockPos pos : this.positions) {
            array[i] = pos.m_121878_();
            ++i;
        }
        nbt.m_128388_("positions", array);
    }

    public void updateValidity(boolean valid, int tier) {
        assert (this.f_58857_ != null);
        this.positions.forEach(pos -> {
            BlockEntity patt1583$temp = this.f_58857_.m_7702_(pos);
            if (patt1583$temp instanceof ClimateReceiver) {
                ClimateReceiver receiver = (ClimateReceiver)patt1583$temp;
                receiver.setValid(this.f_58857_, (BlockPos)pos, valid, tier, this.isCellar);
            } else {
                Block patt1775$temp = this.f_58857_.m_8055_(pos).m_60734_();
                if (patt1775$temp instanceof ClimateReceiver) {
                    ClimateReceiver receiver = (ClimateReceiver)patt1775$temp;
                    receiver.setValid(this.f_58857_, (BlockPos)pos, valid, tier, this.isCellar);
                }
            }
        });
    }

    public void setCellar(boolean cellar) {
        this.isCellar = cellar;
    }

    public void setPositions(Set<BlockPos> positions) {
        this.positions = positions;
    }
}

