/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBeehiveBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeCapability;
import com.eerussianguy.firmalife.common.capabilities.bee.IBee;
import com.eerussianguy.firmalife.common.container.BeehiveContainer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class FLBeehiveBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable {
    public static final int MIN_FLOWERS = 10;
    public static final int UPDATE_INTERVAL = 24000;
    public static final int SLOTS = 4;
    private static final Component NAME = FLHelpers.blockEntityName("beehive");
    private static final FarmlandBlockEntity.NutrientType N = FarmlandBlockEntity.NutrientType.NITROGEN;
    private static final FarmlandBlockEntity.NutrientType P = FarmlandBlockEntity.NutrientType.PHOSPHOROUS;
    private static final FarmlandBlockEntity.NutrientType K = FarmlandBlockEntity.NutrientType.POTASSIUM;
    private final IBee[] cachedBees;
    private long lastPlayerTick;
    private long lastAreaTick;
    private int honey;

    public static void serverTick(Level level, BlockPos pos, BlockState state, FLBeehiveBlockEntity hive) {
        hive.checkForLastTickSync();
        hive.checkForCalendarUpdate();
        if (!level.f_46443_ && level.m_46467_() % 60L == 0L) {
            hive.updateState();
        }
    }

    public FLBeehiveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.BEEHIVE.get(), pos, state, FLBeehiveBlockEntity.defaultInventory((int)4), NAME);
        this.lastPlayerTick = this.lastAreaTick = Calendars.SERVER.getTicks();
        this.cachedBees = new IBee[]{null, null, null, null};
        this.honey = 0;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("lastTick", this.lastPlayerTick);
        nbt.m_128356_("lastAreaTick", this.lastAreaTick);
        nbt.m_128405_("honey", this.honey);
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.updateCache();
        this.lastPlayerTick = nbt.m_128454_("lastTick");
        this.lastAreaTick = nbt.m_128454_("lastAreaTick");
        this.honey = nbt.m_128451_("honey");
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return BeehiveContainer.create(this, inv, windowID);
    }

    public void onCalendarUpdate(long ticks) {
        long now = Calendars.SERVER.getTicks();
        if (now > this.lastAreaTick + 24000L) {
            while (this.lastAreaTick < now) {
                this.updateTick();
                this.lastAreaTick += 24000L;
            }
            this.markForSync();
        }
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.updateCache();
    }

    private void updateCache() {
        for (int i = 0; i < 4; ++i) {
            this.cachedBees[i] = this.getBee(i);
        }
    }

    public IBee[] getCachedBees() {
        return this.cachedBees;
    }

    private void updateTick() {
        assert (this.f_58857_ != null);
        int minX = this.f_58858_.m_123341_() - 5;
        int maxX = this.f_58858_.m_123341_() + 5;
        int minZ = this.f_58858_.m_123343_() - 5;
        int maxZ = this.f_58858_.m_123343_() + 5;
        float temp = Climate.getTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_);
        ArrayList<IBee> usableBees = new ArrayList<IBee>();
        int breedTickChanceInverted = 0;
        int honeyChanceInverted = 0;
        for (int b = 0; b < 4; ++b) {
            IBee bee = this.cachedBees[b];
            if (bee == null || !bee.hasQueen() || !(temp > BeeAbility.getMinTemperature(bee.getAbility(BeeAbility.HARDINESS)))) continue;
            usableBees.add(bee);
            breedTickChanceInverted += 10 - bee.getAbility(BeeAbility.FERTILITY);
            honeyChanceInverted += 10 - bee.getAbility(BeeAbility.PRODUCTION);
        }
        boolean empty = usableBees.isEmpty();
        int flowers = 0;
        if (this.f_58857_.m_151572_(minX, maxX, minZ, maxZ)) {
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)(this.f_58858_.m_123342_() - 5), (int)minZ, (int)maxX, (int)(this.f_58858_.m_123342_() + 5), (int)maxZ)) {
                if (empty) {
                    flowers += this.tickPosition(pos, null);
                    continue;
                }
                for (IBee bee : usableBees) {
                    flowers += this.tickPosition(pos, bee);
                }
            }
        }
        if (empty) {
            breedTickChanceInverted = 20;
        }
        breedTickChanceInverted = Math.max(0, breedTickChanceInverted - flowers);
        if (flowers > 10 && (breedTickChanceInverted == 0 || this.f_58857_.f_46441_.nextInt(breedTickChanceInverted) == 0)) {
            IBee parent1 = null;
            IBee parent2 = null;
            IBee uninitializedBee = null;
            for (int i = 0; i < 4; ++i) {
                IBee bee = ((ItemStackHandler)this.inventory).getStackInSlot(i).getCapability(BeeCapability.CAPABILITY).resolve().orElse(null);
                if (bee == null) continue;
                if (bee.hasQueen()) {
                    if (parent1 == null) {
                        parent1 = bee;
                        continue;
                    }
                    if (parent2 != null) continue;
                    parent2 = bee;
                    continue;
                }
                if (uninitializedBee != null) continue;
                uninitializedBee = bee;
            }
            if (uninitializedBee != null) {
                if (parent2 == null) {
                    uninitializedBee.initFreshAbilities(this.f_58857_.f_46441_);
                } else if (parent1.hasQueen() && parent2.hasQueen()) {
                    uninitializedBee.setAbilitiesFromParents(parent1, parent2, this.f_58857_.f_46441_);
                }
            }
        }
        if (!usableBees.isEmpty()) {
            honeyChanceInverted /= usableBees.size();
        }
        if (flowers > 10 && honeyChanceInverted > 0 && this.f_58857_.f_46441_.nextInt(honeyChanceInverted) == 0) {
            this.addHoney(usableBees.size());
        }
    }

    public void addHoney(int amount) {
        this.honey = Math.min(16, amount + this.honey);
        this.markForSync();
    }

    public int takeHoney(int amount) {
        int take = Math.min(amount, this.honey);
        this.honey -= take;
        this.markForSync();
        return take;
    }

    public int getHoney() {
        return this.honey;
    }

    private int tickPosition(BlockPos pos, @Nullable IBee bee) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(pos);
        boolean beePlant = Helpers.isBlock((BlockState)state, FLTags.Blocks.BEE_PLANTS);
        if (bee != null) {
            int restore;
            Block block = state.m_60734_();
            boolean soil = block instanceof FarmlandBlock;
            boolean planter = block instanceof LargePlanterBlock;
            if (planter || soil) {
                float cropAffinity = bee.getAbility(BeeAbility.CROP_AFFINITY);
                float nitrogen = this.f_58857_.f_46441_.nextFloat() * cropAffinity * 0.1f;
                float potassium = this.f_58857_.f_46441_.nextFloat() * cropAffinity * 0.1f;
                float phosphorous = this.f_58857_.f_46441_.nextFloat() * cropAffinity * 0.1f;
                float cap = (cropAffinity - 1.0f) * 0.5f;
                if (soil) {
                    this.f_58857_.m_141902_(pos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).ifPresent(farmland -> this.receiveNutrients(arg_0 -> ((FarmlandBlockEntity)farmland).getNutrient(arg_0), (arg_0, arg_1) -> ((FarmlandBlockEntity)farmland).setNutrient(arg_0, arg_1), cap, nitrogen, phosphorous, potassium));
                } else {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (blockEntity instanceof LargePlanterBlockEntity) {
                        LargePlanterBlockEntity planterEntity = (LargePlanterBlockEntity)blockEntity;
                        this.receiveNutrients(planterEntity::getNutrient, planterEntity::setNutrient, cap, nitrogen, phosphorous, potassium);
                    }
                }
            }
            if ((restore = bee.getAbility(BeeAbility.NATURE_RESTORATION)) > 1 && this.f_58857_.f_46441_.nextInt(50 + 50 * (10 - restore)) == 0) {
                BlockPos above = pos.m_7494_();
                boolean airAbove = this.f_58857_.m_8055_(above).m_60795_();
                if (airAbove && Helpers.isFluid((FluidState)state.m_60819_(), (Fluid)Fluids.f_76193_)) {
                    Helpers.getRandomElement((IForgeRegistry)ForgeRegistries.BLOCKS, FLTags.Blocks.BEE_RESTORATION_WATER_PLANTS, (Random)this.f_58857_.f_46441_).ifPresent(plant -> this.f_58857_.m_46597_(pos, plant.m_49966_()));
                } else if (airAbove && block instanceof DirtBlock) {
                    DirtBlock dirt = (DirtBlock)block;
                    this.f_58857_.m_46597_(pos, dirt.getGrass());
                } else if (state.m_60795_() && this.f_58857_.m_8055_(pos.m_7495_()).m_60734_() instanceof ConnectedGrassBlock) {
                    Helpers.getRandomElement((IForgeRegistry)ForgeRegistries.BLOCKS, FLTags.Blocks.BEE_RESTORATION_PLANTS, (Random)this.f_58857_.f_46441_).ifPresent(plant -> this.f_58857_.m_46597_(pos, plant.m_49966_()));
                }
            }
        }
        return beePlant ? 1 : 0;
    }

    private void receiveNutrients(Function<FarmlandBlockEntity.NutrientType, Float> getter, BiConsumer<FarmlandBlockEntity.NutrientType, Float> setter, float cap, float nitrogen, float phosphorous, float potassium) {
        float k;
        float p;
        float n = getter.apply(N).floatValue();
        if (n < cap) {
            setter.accept(N, Float.valueOf(Math.min(n + nitrogen, cap)));
        }
        if ((p = getter.apply(N).floatValue()) < cap) {
            setter.accept(P, Float.valueOf(Math.min(p + phosphorous, cap)));
        }
        if ((k = getter.apply(K).floatValue()) < cap) {
            setter.accept(K, Float.valueOf(Math.min(k + potassium, cap)));
        }
    }

    public void updateState() {
        boolean hasHoney;
        BlockState state;
        assert (this.f_58857_ != null);
        boolean bees = this.hasBees();
        if (bees != (Boolean)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)FLBeehiveBlock.BEES)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FLBeehiveBlock.BEES, (Comparable)Boolean.valueOf(bees)));
        }
        boolean bl = hasHoney = this.honey > 0;
        if (hasHoney != (Boolean)state.m_61143_((Property)FLBeehiveBlock.HONEY)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FLBeehiveBlock.HONEY, (Comparable)Boolean.valueOf(hasHoney)));
        }
    }

    private boolean hasBees() {
        for (int i = 0; i < 4; ++i) {
            if (this.cachedBees[i] == null || !this.cachedBees[i].hasQueen()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IBee getBee(int slot) {
        Optional opt;
        ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
        if (!stack.m_41619_() && (opt = stack.getCapability(BeeCapability.CAPABILITY).resolve()).isPresent()) {
            return (IBee)opt.get();
        }
        return null;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getCapability(BeeCapability.CAPABILITY).isPresent();
    }

    public void onSlotTake(Player player, int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        if (FLBeehiveBlock.shouldAnger(this.f_58857_, this.f_58858_)) {
            FLBeehiveBlock.attack(player);
        }
    }

    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }
}

