/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IronComposterBlockEntity
extends ComposterBlockEntity {
    public IronComposterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.COMPOSTER.get(), pos, state);
    }

    public void randomTick() {
        if (this.getGreen() >= 4 && this.getBrown() >= 4 & !this.isRotten()) {
            assert (this.f_58857_ != null);
            float rainfall = Climate.getRainfall((Level)this.f_58857_, (BlockPos)this.m_58899_());
            long readyTicks = (Integer)TFCConfig.SERVER.composterTicks.get() / 4;
            if (((Boolean)TFCConfig.SERVER.composterRainfallCheck.get()).booleanValue()) {
                if (rainfall < 150.0f) {
                    readyTicks *= (long)((150.0f - rainfall) / 50.0f + 1.0f);
                } else if (rainfall > 350.0f) {
                    readyTicks *= (long)((rainfall - 350.0f) / 50.0f + 1.0f);
                }
            }
            if (this.getTicksSinceUpdate() > readyTicks) {
                this.setState(TFCComposterBlock.CompostType.READY);
                this.markForSync();
            }
        }
    }

    private void setState(TFCComposterBlock.CompostType type) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)TFCComposterBlock.TYPE, (Comparable)type));
    }

    private boolean isRotten() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.ROTTEN;
    }
}

