/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import com.eerussianguy.firmalife.common.util.Mechanics;
import com.eerussianguy.firmalife.common.util.Plantable;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LargePlanterBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable,
ClimateReceiver {
    public static final Component NAME = FLHelpers.blockEntityName("large_planter");
    public static final FarmlandBlockEntity.NutrientType[] NUTRIENTS = FarmlandBlockEntity.NutrientType.values();
    protected static final int LARGE_PLANTER_SLOTS = 1;
    @Nullable
    private Plantable cachedPlant = null;
    private float growth = 0.0f;
    private float nitrogen = 0.0f;
    private float phosphorous = 0.0f;
    private float potassium = 0.0f;
    private float water = 0.0f;
    private long lastPlayerTick = Calendars.SERVER.getTicks();
    private boolean climateValid = false;
    private int tier = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, LargePlanterBlockEntity planter) {
        planter.checkForCalendarUpdate();
        planter.checkForLastTickSync();
    }

    public LargePlanterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FLBlockEntities.LARGE_PLANTER.get(), pos, state, (InventoryBlockEntity.InventoryFactory<ItemStackHandler>)LargePlanterBlockEntity.defaultInventory((int)1), NAME);
    }

    public LargePlanterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<ItemStackHandler> inventoryFactory, Component defaultName) {
        super(type, pos, state, inventoryFactory, defaultName);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Plantable.get(stack) != null;
    }

    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() instanceof LargePlanterBlock && !this.f_58857_.f_46443_ && Mechanics.growthTick(this.f_58857_, this.f_58858_, state, this)) {
            this.updateBlockState(state);
        }
    }

    protected void updateBlockState(BlockState state) {
        boolean waterNow;
        assert (this.f_58857_ != null);
        boolean waterLast = (Boolean)state.m_61143_((Property)LargePlanterBlock.WATERED);
        boolean bl = waterNow = this.water > 0.0f;
        if (waterNow != waterLast) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)LargePlanterBlock.WATERED, (Comparable)Boolean.valueOf(waterNow)));
        }
    }

    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    public void setLastUpdateTick(long ticks) {
        this.lastPlayerTick = ticks;
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.climateValid = nbt.m_128471_("valid");
        this.lastPlayerTick = nbt.m_128454_("lastPlayerTick");
        this.climateValid = nbt.m_128471_("climateValid");
        this.nitrogen = nbt.m_128457_("n");
        this.phosphorous = nbt.m_128457_("p");
        this.potassium = nbt.m_128457_("k");
        this.water = nbt.m_128457_("water");
        this.tier = nbt.m_128451_("tier");
        this.loadUnique(nbt);
        this.updateCache();
    }

    protected void loadUnique(CompoundTag nbt) {
        this.growth = nbt.m_128457_("growth");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("valid", this.climateValid);
        nbt.m_128356_("lastPlayerTick", this.lastPlayerTick);
        nbt.m_128379_("climateValid", this.climateValid);
        nbt.m_128350_("n", this.nitrogen);
        nbt.m_128350_("p", this.phosphorous);
        nbt.m_128350_("k", this.potassium);
        nbt.m_128350_("water", this.water);
        nbt.m_128405_("tier", this.tier);
        this.saveUnique(nbt);
    }

    protected void saveUnique(CompoundTag nbt) {
        nbt.m_128350_("growth", this.growth);
    }

    public void updateCache() {
        this.cachedPlant = Plantable.get(((ItemStackHandler)this.inventory).getStackInSlot(0));
    }

    public boolean checkValid() {
        BlockPos offset;
        assert (this.f_58857_ != null);
        Direction dir = this.airFindOffset();
        if (dir != null ? !this.skylightValid(offset = this.f_58858_.m_142300_(dir)) || !this.f_58857_.m_8055_(offset).m_60795_() : !this.skylightValid(this.f_58858_)) {
            return false;
        }
        return this.climateValid && this.water > 0.0f;
    }

    private boolean skylightValid(BlockPos pos) {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_45517_(LightLayer.SKY, pos) >= this.f_58857_.m_7469_() - 5;
    }

    public boolean isClimateValid() {
        return this.climateValid;
    }

    public Component getInvalidReason() {
        assert (this.f_58857_ != null);
        String complaint = "error_unknown";
        if (!this.climateValid) {
            complaint = "climate_invalid";
        } else if (this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_.m_142300_(Direction.UP)) < this.f_58857_.m_7469_() - 5) {
            complaint = "no_sky";
        } else if (!this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60795_()) {
            complaint = "air_above";
        } else if (this.water <= 0.0f) {
            complaint = "dehydrated";
        }
        return new TranslatableComponent("firmalife.greenhouse." + complaint);
    }

    @Nullable
    protected Direction airFindOffset() {
        return Direction.UP;
    }

    public int getTier() {
        return this.tier;
    }

    public int slots() {
        return 1;
    }

    public float getGrowth(int slot) {
        return this.growth;
    }

    public void setGrowth(int slot, float growth) {
        if (growth > 0.99f) {
            growth = 1.0f;
        }
        this.growth = growth;
        this.markForSync();
    }

    @Nullable
    public Plantable getPlantable(int slot) {
        return this.cachedPlant;
    }

    public float getNutrient(FarmlandBlockEntity.NutrientType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FarmlandBlockEntity.NutrientType.NITROGEN -> this.nitrogen;
            case FarmlandBlockEntity.NutrientType.PHOSPHOROUS -> this.phosphorous;
            case FarmlandBlockEntity.NutrientType.POTASSIUM -> this.potassium;
        };
    }

    public void setNutrient(FarmlandBlockEntity.NutrientType type, float amount) {
        amount = Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f);
        switch (type) {
            case NITROGEN: {
                this.nitrogen = amount;
                break;
            }
            case POTASSIUM: {
                this.potassium = amount;
                break;
            }
            case PHOSPHOROUS: {
                this.phosphorous = amount;
            }
        }
    }

    public void addNutrient(FarmlandBlockEntity.NutrientType type, float amount) {
        this.setNutrient(type, this.getNutrient(type) + amount);
    }

    public void setAndUpdateSlots(int slot) {
        this.updateCache();
    }

    @Override
    public void addWater(float amount) {
        assert (this.f_58857_ != null);
        this.water = Math.min(this.water + amount, 1.0f);
        this.updateBlockState(this.f_58857_.m_8055_(this.f_58858_));
        this.markForSync();
    }

    public void drainWater(float amount) {
        assert (this.f_58857_ != null);
        this.water = Math.max(0.0f, this.water - amount);
        this.updateBlockState(this.f_58857_.m_8055_(this.f_58858_));
        this.markForSync();
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, boolean cellar) {
        if (!cellar) {
            this.climateValid = valid;
            this.tier = tier;
        }
        this.markForSync();
    }

    public float getWater() {
        return this.water;
    }

    public float consumeNutrientAndResupplyOthers(FarmlandBlockEntity.NutrientType type, float amount) {
        float startValue = this.getNutrient(type);
        float consumed = Math.min(startValue, amount);
        this.setNutrient(type, startValue - consumed);
        for (FarmlandBlockEntity.NutrientType other : NUTRIENTS) {
            if (other == type) continue;
            this.addNutrient(other, consumed * 0.16666667f);
        }
        return consumed;
    }

    public void addNutrients(Fertilizer fertilizer) {
        this.addNutrient(FarmlandBlockEntity.NutrientType.NITROGEN, fertilizer.getNitrogen());
        this.addNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, fertilizer.getPhosphorus());
        this.addNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM, fertilizer.getPotassium());
        this.markForSync();
    }

    public void afterGrowthTickStep(boolean wasGrowing) {
    }
}

