/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.ICure;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class OvenBottomBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable {
    public static final int SLOT_FUEL_MIN = 0;
    public static final int SLOT_FUEL_MAX = 3;
    public static final int CURE_TICKS = 40;
    private static final int MAX_AIR_TICKS = 600;
    private int burnTicks = 0;
    private float burnTemperature;
    private long lastPlayerTick;
    private boolean needsSlotUpdate;
    private int airTicks = 0;
    private int cureTicks = 0;
    float temperature = this.burnTemperature = (float)0;

    public static void cure(Level level, BlockState oldState, BlockState newState, BlockPos pos) {
        BlockState placeState = (BlockState)((BlockState)((BlockState)newState.m_61124_((Property)OvenBottomBlock.FACING, (Comparable)((Direction)oldState.m_61143_((Property)OvenBottomBlock.FACING)))).m_61124_((Property)OvenBottomBlock.LOGS, (Comparable)((Integer)oldState.m_61143_((Property)OvenBottomBlock.LOGS)))).m_61124_((Property)OvenBottomBlock.LIT, (Comparable)((Boolean)oldState.m_61143_((Property)OvenBottomBlock.LIT)));
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get()).ifPresent(oven -> {
            float temperature = oven.temperature;
            int burnTicks = oven.burnTicks;
            float burnTemperature = oven.burnTemperature;
            long lastPlayerTick = oven.lastPlayerTick;
            int airTicks = oven.airTicks;
            NonNullList items = Helpers.extractAllItems((IItemHandlerModifiable)oven.inventory);
            level.m_46597_(pos, placeState);
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get()).ifPresent(newOven -> {
                newOven.temperature = temperature;
                newOven.burnTicks = burnTicks;
                newOven.burnTemperature = burnTemperature;
                newOven.lastPlayerTick = lastPlayerTick;
                newOven.airTicks = airTicks;
                Helpers.insertAllItems((IItemHandlerModifiable)newOven.inventory, (NonNullList)items);
                newOven.markForSync();
            });
        });
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OvenBottomBlockEntity oven) {
        oven.checkForLastTickSync();
        oven.checkForCalendarUpdate();
        if (level.m_46467_() % 40L == 0L) {
            ICure cure;
            boolean cured;
            Block block = state.m_60734_();
            boolean bl = cured = block instanceof ICure && (cure = (ICure)block).isCured();
            if (oven.cureTicks <= 40) {
                ++oven.cureTicks;
            }
            if (oven.temperature > 600.0f && oven.cureTicks > 40) {
                AbstractOvenBlock.cureAllAround(level, pos, !cured);
            }
            oven.updateLogs();
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            if (oven.burnTicks > 0) {
                oven.burnTicks = oven.burnTicks - (oven.airTicks > 0 ? 2 : 1);
            }
            if (oven.burnTicks <= 0 && !oven.consumeFuel()) {
                oven.extinguish(state);
            }
        } else if (oven.burnTemperature > 0.0f) {
            oven.extinguish(state);
        }
        if (oven.airTicks > 0) {
            --oven.airTicks;
        }
        if (oven.temperature > 0.0f || oven.burnTemperature > 0.0f) {
            oven.temperature = HeatCapability.adjustDeviceTemp((float)oven.temperature, (float)oven.burnTemperature, (int)oven.airTicks, (boolean)false);
            BlockEntity above = level.m_7702_(pos.m_7494_());
            if (above != null) {
                above.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> cap.setTemperatureIfWarmer(oven.temperature));
            }
            oven.markForSync();
        }
        if (oven.needsSlotUpdate) {
            oven.cascadeFuelSlots();
            oven.updateLogs();
        }
    }

    public OvenBottomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get(), pos, state, OvenBottomBlockEntity.defaultInventory((int)4), FLHelpers.blockEntityName("oven_bottom"));
        this.lastPlayerTick = Calendars.SERVER.getTicks();
    }

    public void onCalendarUpdate(long ticks) {
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks((long)ticks, (IItemHandlerModifiable)this.inventory, (int)this.burnTicks, (float)this.burnTemperature, (int)0, (int)3);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(state);
            }
        }
    }

    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    public void setLastUpdateTick(long ticks) {
        this.lastPlayerTick = ticks;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("temperature");
        this.burnTicks = nbt.m_128451_("burnTicks");
        this.airTicks = nbt.m_128451_("airTicks");
        this.burnTemperature = nbt.m_128457_("burnTemperature");
        this.lastPlayerTick = nbt.m_128454_("lastPlayerTick");
        this.cureTicks = nbt.m_128451_("cureTicks");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128405_("burnTicks", this.burnTicks);
        nbt.m_128405_("airTicks", this.airTicks);
        nbt.m_128350_("burnTemperature", this.burnTemperature);
        nbt.m_128356_("lastPlayerTick", this.lastPlayerTick);
        nbt.m_128405_("cureTicks", this.cureTicks);
        super.m_183515_(nbt);
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem((ItemStack)stack, FLTags.Items.OVEN_FUEL);
    }

    private boolean consumeFuel() {
        ItemStack fuelStack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (!fuelStack.m_41619_()) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, ItemStack.f_41583_);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get((ItemStack)fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.getDuration();
                this.burnTemperature = fuel.getTemperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    public boolean light(BlockState state) {
        assert (this.f_58857_ != null);
        if (this.consumeFuel()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    public void extinguish(BlockState state) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
        this.burnTemperature = 0.0f;
        this.burnTicks = 0;
        this.markForSync();
    }

    public void onAirIntake(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i <= 3; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (i > lowestAvailSlot) {
                ((ItemStackHandler)this.inventory).setStackInSlot(lowestAvailSlot, stack.m_41777_());
                ((ItemStackHandler)this.inventory).setStackInSlot(i, ItemStack.f_41583_);
            }
            ++lowestAvailSlot;
        }
        this.needsSlotUpdate = false;
    }

    private void updateLogs() {
        assert (this.f_58857_ != null);
        int logs = this.countLogs();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if ((Integer)state.m_61143_((Property)OvenBottomBlock.LOGS) != logs) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)OvenBottomBlock.LOGS, (Comparable)Integer.valueOf(logs)));
        }
    }

    private int countLogs() {
        int logs = 0;
        for (int i = 0; i <= 3; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ++logs;
        }
        return logs;
    }
}

