/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.ICure;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenTopBlockEntity
extends TickableInventoryBlockEntity<OvenInventory>
implements ICalendarTickable {
    public static final int SLOTS = 4;
    public static final int SLOT_INPUT_END = 3;
    public static final int SLOT_INPUT_START = 0;
    public static final int TARGET_TEMPERATURE_STABILITY_TICKS = 400;
    public static final float CURE_TEMP = 600.0f;
    public static final int COOK_TIME = 2000;
    private final SidedHandler.Noop<IHeatBlock> sidedHeat;
    float temperature = this.targetTemperature = (float)0;
    private float targetTemperature;
    private int targetTemperatureStabilityTicks = 0;
    private long lastUpdateTick = Calendars.SERVER.getTicks();
    private boolean needsRecipeUpdate;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[4];
    private int[] cookTicks = new int[]{0, 0, 0, 0};
    private int cureTicks = 0;

    public static void cure(Level level, BlockState oldState, BlockState newState, BlockPos pos) {
        BlockState placeState = (BlockState)newState.m_61124_((Property)OvenBottomBlock.FACING, (Comparable)((Direction)oldState.m_61143_((Property)OvenBottomBlock.FACING)));
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).ifPresent(oven -> {
            float temperature = oven.temperature;
            float targetTemperature = oven.targetTemperature;
            int targetTemperatureStabilityTicks = oven.targetTemperatureStabilityTicks;
            NonNullList items = Helpers.extractAllItems((IItemHandlerModifiable)oven.inventory);
            level.m_46597_(pos, placeState);
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).ifPresent(newOven -> {
                newOven.temperature = temperature;
                newOven.targetTemperature = targetTemperature;
                newOven.targetTemperatureStabilityTicks = targetTemperatureStabilityTicks;
                Helpers.insertAllItems((IItemHandlerModifiable)newOven.inventory, (NonNullList)items);
                newOven.markForSync();
            });
        });
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OvenTopBlockEntity oven) {
        ICure cure;
        Block block;
        boolean cured;
        oven.checkForLastTickSync();
        oven.checkForCalendarUpdate();
        if (oven.needsRecipeUpdate) {
            oven.needsRecipeUpdate = false;
            oven.updateCaches();
        }
        if (oven.temperature != oven.targetTemperature) {
            oven.temperature = HeatCapability.adjustTempTowards((float)oven.temperature, (float)oven.targetTemperature);
        }
        boolean bl = cured = (block = state.m_60734_()) instanceof ICure && (cure = (ICure)block).isCured();
        if (level.m_46467_() % 40L == 0L) {
            if (oven.cureTicks < 40) {
                ++oven.cureTicks;
            }
            if (oven.temperature > 600.0f && oven.cureTicks > 40) {
                AbstractOvenBlock.cureAllAround(level, pos, !cured);
            }
        }
        if (oven.targetTemperatureStabilityTicks > 0) {
            --oven.targetTemperatureStabilityTicks;
        }
        if (oven.targetTemperature > 0.0f && oven.targetTemperatureStabilityTicks == 0) {
            oven.targetTemperature = HeatCapability.adjustTempTowards((float)oven.targetTemperature, (float)0.0f);
        }
        if (!cured) {
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            int slot = i;
            ItemStack inputStack = ((OvenInventory)oven.inventory).getStackInSlot(i);
            if (inputStack.m_41619_()) continue;
            inputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> {
                HeatingRecipe recipe;
                if (cap.getTemperature() < oven.temperature) {
                    HeatCapability.addTemp((IHeat)cap, (float)oven.temperature, (float)(2.0f + oven.temperature * 0.0025f));
                }
                if ((recipe = oven.cachedRecipes[slot]) != null && recipe.isValidTemperature(cap.getTemperature())) {
                    int n = slot;
                    int n2 = oven.cookTicks[n];
                    oven.cookTicks[n] = n2 + 1;
                    if (n2 > 2000) {
                        ItemStackInventory inventory = new ItemStackInventory(inputStack);
                        ItemStack outputItem = recipe.assemble(inventory);
                        outputItem.getCapability(HeatCapability.CAPABILITY).ifPresent(outputCap -> outputCap.setTemperature(oven.temperature));
                        FoodCapability.applyTrait((ItemStack)outputItem, (FoodTrait)FLFoodTraits.OVEN_BAKED);
                        ((OvenInventory)oven.inventory).setStackInSlot(slot, outputItem);
                        oven.markForSync();
                    }
                }
            });
        }
    }

    public OvenTopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.OVEN_TOP.get(), pos, state, OvenInventory::new, FLHelpers.blockEntityName("oven_top"));
        this.sidedHeat = new SidedHandler.Noop((Object)((IHeatBlock)this.inventory));
    }

    public void loadAdditional(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("temperature");
        this.targetTemperature = nbt.m_128457_("targetTemperature");
        this.targetTemperatureStabilityTicks = nbt.m_128451_("targetTemperatureStabilityTicks");
        this.cookTicks = nbt.m_128465_("cookTicks");
        this.cureTicks = nbt.m_128451_("cureTicks");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128350_("targetTemperature", this.targetTemperature);
        nbt.m_128405_("targetTemperatureStabilityTicks", this.targetTemperatureStabilityTicks);
        nbt.m_128385_("cookTicks", this.cookTicks);
        nbt.m_128405_("cureTicks", this.cureTicks);
        super.m_183515_(nbt);
    }

    public float getTemperature() {
        return this.temperature;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == HeatCapability.BLOCK_CAPABILITY) {
            return this.sidedHeat.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        this.targetTemperature = HeatCapability.adjustTempTowards((float)this.targetTemperature, (float)0.0f, (float)ticks);
        this.temperature = HeatCapability.adjustTempTowards((float)this.temperature, (float)this.targetTemperature, (float)ticks);
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public void setLastUpdateTick(long ticks) {
        this.lastUpdateTick = ticks;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.singleRecipeUpdate(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getCapability(HeatCapability.CAPABILITY).isPresent();
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    private void updateCaches() {
        for (int slot = 0; slot <= 3; ++slot) {
            this.singleRecipeUpdate(slot);
        }
    }

    private void singleRecipeUpdate(int slot) {
        HeatingRecipe previous = this.cachedRecipes[slot];
        this.cachedRecipes[slot] = HeatingRecipe.getRecipe((ItemStack)((OvenInventory)this.inventory).getStackInSlot(slot));
        if (previous != this.cachedRecipes[slot] || this.cachedRecipes[slot] == null) {
            this.cookTicks[slot] = 0;
        }
    }

    public void extinguish() {
        for (int i = 0; i < 3; ++i) {
            this.cookTicks[i] = 0;
            this.cachedRecipes[i] = null;
        }
        this.temperature = 0.0f;
        this.targetTemperature = 0.0f;
        this.targetTemperatureStabilityTicks = 0;
    }

    static class OvenInventory
    implements DelegateItemHandler,
    IHeatBlock,
    INBTSerializable<CompoundTag> {
        private final OvenTopBlockEntity oven;
        private final InventoryItemHandler inventory;

        public OvenInventory(InventoryBlockEntity<?> blockEntity) {
            this.oven = (OvenTopBlockEntity)blockEntity;
            this.inventory = new InventoryItemHandler(blockEntity, 4);
        }

        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public float getTemperature() {
            return this.oven.temperature;
        }

        public void setTemperature(float temperature) {
            this.oven.targetTemperature = temperature;
            this.oven.targetTemperatureStabilityTicks = 400;
            this.oven.markForSync();
        }

        public void setTemperatureIfWarmer(float temperature) {
            if (temperature >= this.oven.temperature) {
                this.oven.temperature = temperature;
                this.oven.targetTemperatureStabilityTicks = 400;
                this.oven.markForSync();
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }
}

