/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemRecipeBlockEntity<T extends SimpleItemRecipe>
extends InventoryBlockEntity<ItemStackHandler> {
    private final int duration;
    protected long startTick;
    @Nullable
    protected T cachedRecipe;

    public SimpleItemRecipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component defaultName, int duration) {
        super(type, pos, state, SimpleItemRecipeBlockEntity.defaultInventory((int)1), defaultName);
        this.duration = duration;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.startTick = nbt.m_128454_("startTick");
        super.loadAdditional(nbt);
        this.updateCache();
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("startTick", this.startTick);
        super.m_183515_(nbt);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    abstract void updateCache();

    public void start() {
        assert (this.f_58857_ != null);
        this.updateCache();
        if (this.cachedRecipe != null) {
            this.startTick = Calendars.SERVER.getTicks();
            if (!this.f_58857_.m_45527_(this.f_58858_.m_7494_())) {
                this.startTick += (long)this.duration;
            }
            this.markForSync();
        }
    }

    public void finish() {
        T recipe = this.cachedRecipe;
        if (recipe != null) {
            ItemStack out = recipe.assemble(new ItemStackInventory(this.readStack()));
            ((ItemStackHandler)this.inventory).setStackInSlot(0, out);
            this.updateCache();
            this.markForSync();
        }
    }

    public ItemStack insert(ItemStack item) {
        return ((ItemStackHandler)this.inventory).insertItem(0, item, false);
    }

    public ItemStack extract() {
        return ((ItemStackHandler)this.inventory).extractItem(0, 1, false);
    }

    public ItemStack readStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41777_();
    }

    public int getDuration() {
        return this.duration;
    }
}

