/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.client.FLClientHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import com.eerussianguy.firmalife.common.blocks.ICure;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOvenBlock
extends FourWayDeviceBlock
implements ICure {
    @Nullable
    private final Supplier<? extends Block> curedBlock;

    public static boolean insulated(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (d == state.m_61143_((Property)FACING)) continue;
            mutable.m_122190_((Vec3i)pos).m_122173_(d);
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            if (Helpers.isBlock((BlockState)stateAt, FLTags.Blocks.OVEN_INSULATION)) continue;
            return false;
        }
        return true;
    }

    public static void cureAllAround(Level level, BlockPos pos, boolean myself) {
        Block block;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Helpers.DIRECTIONS) {
            mutable.m_122190_((Vec3i)pos).m_122173_(d);
            BlockState state = level.m_8055_((BlockPos)mutable);
            Block block2 = state.m_60734_();
            if (!(block2 instanceof ICure)) continue;
            ICure oven = (ICure)block2;
            oven.cure(level, state, (BlockPos)mutable);
        }
        BlockState myState = level.m_8055_(pos);
        if (myself && (block = myState.m_60734_()) instanceof ICure) {
            ICure oven = (ICure)block;
            oven.cure(level, myState, pos);
        }
    }

    public AbstractOvenBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> curedBlock) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.curedBlock = curedBlock;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        FLClientHelpers.randomParticle((ParticleOptions)ParticleTypes.f_123762_, random, pos, level, 0.05f);
        FLClientHelpers.randomParticle((ParticleOptions)ParticleTypes.f_123744_, random, pos, level, 0.05f);
        pos = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        BlockState stateAt = level.m_8055_(pos);
        if (Helpers.isBlock((BlockState)stateAt, FLTags.Blocks.CHIMNEYS)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            mutable.m_122190_((Vec3i)pos);
            do {
                mutable.m_122173_(Direction.UP);
            } while (Helpers.isBlock((BlockState)(stateAt = level.m_8055_((BlockPos)mutable)), FLTags.Blocks.CHIMNEYS));
            FLClientHelpers.randomParticle((ParticleOptions)ParticleTypes.f_123777_, random, (BlockPos)mutable, level, 0.05f);
        } else if (level.m_8055_(pos = pos.m_142082_(Helpers.triangle((Random)random, (int)3), random.nextInt(3), Helpers.triangle((Random)random, (int)3))).m_60795_()) {
            FLClientHelpers.randomParticle((ParticleOptions)ParticleTypes.f_123777_, random, pos, level, 0.3f);
        }
    }

    @Override
    public Block getCured() {
        return this.curedBlock == null ? null : this.curedBlock.get();
    }
}

