/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeCapability;
import com.eerussianguy.firmalife.common.capabilities.bee.IBee;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.misc.FLEffects;
import com.eerussianguy.firmalife.common.misc.SwarmEffect;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class FLBeehiveBlock
extends FourWayDeviceBlock
implements HoeOverlayBlock {
    public static final BooleanProperty HONEY = FLStateProperties.HONEY;
    public static final BooleanProperty BEES = FLStateProperties.BEES;

    public static boolean shouldAnger(Level level, BlockPos pos) {
        if (level.m_46942_(1.0f) > 12000.0f) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        for (int i = 0; i < 5; ++i) {
            mutable.m_122184_(0, -1, 0);
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (state.m_60795_()) continue;
            if (!Helpers.isBlock((BlockState)state, (Block)((Block)TFCBlocks.FIREPIT.get())) || !((Boolean)state.m_61143_((Property)FirepitBlock.LIT)).booleanValue()) break;
            return false;
        }
        return level.m_141902_(pos, (BlockEntityType)FLBlockEntities.BEEHIVE.get()).map(hive -> hive.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> {
            float calmChance = 0.0f;
            for (int i = 0; i < 4; ++i) {
                IBee bee = inv.getStackInSlot(i).getCapability(BeeCapability.CAPABILITY).resolve().orElse(null);
                if (bee != null && bee.hasQueen()) {
                    calmChance += (float)bee.getAbility(BeeAbility.CALMNESS);
                }
                calmChance /= 40.0f;
            }
            return level.f_46441_.nextFloat() > calmChance;
        }).orElse(false)).orElse(false);
    }

    public static void attack(Player player) {
        player.m_7292_(new MobEffectInstance((MobEffect)FLEffects.SWARM.get(), 100));
    }

    public FLBeehiveBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HONEY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BEES, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        if (Helpers.isItem((ItemStack)held, (Item)((Item)FLItems.EMPTY_JAR.get())) && !player.m_6144_()) {
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.BEEHIVE.get()).ifPresent(hive -> {
                if (hive.takeHoney(1) > 0) {
                    held.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)FLBlocks.HONEY_JAR.get()));
                }
            });
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!player.m_6144_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.m_141902_(pos, (BlockEntityType)FLBlockEntities.BEEHIVE.get()).ifPresent(nest -> NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)nest, (BlockPos)pos));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)BEES)).booleanValue() && level.m_46942_(1.0f) < 12000.0f) {
            SwarmEffect.particles(level, pos, random);
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack tool) {
        if (FLBeehiveBlock.shouldAnger(level, pos)) {
            FLBeehiveBlock.attack(player);
        }
        super.m_6240_(level, player, pos, state, entity, tool);
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState blockState, List<Component> text, boolean debug) {
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.BEEHIVE.get()).ifPresent(hive -> {
            if (hive.getHoney() > 0) {
                text.add((Component)Helpers.translatable((String)"firmalife.beehive.honey", (Object[])new Object[]{String.valueOf(hive.getHoney())}).m_130940_(ChatFormatting.GOLD));
            }
            float temp = Climate.getTemperature((Level)level, (BlockPos)pos);
            int ord = 0;
            for (IBee bee : hive.getCachedBees()) {
                TranslatableComponent beeText = Helpers.translatable((String)"firmalife.beehive.bee", (Object[])new Object[]{String.valueOf(++ord)});
                if (bee.hasQueen()) {
                    beeText.m_7220_((Component)Helpers.translatable((String)"firmalife.beehive.has_queen"));
                    float minTemp = BeeAbility.getMinTemperature(bee.getAbility(BeeAbility.HARDINESS));
                    if (temp < minTemp) {
                        beeText.m_7220_((Component)Helpers.translatable((String)"firmalife.beehive.bee_cold", (Object[])new Object[]{Float.valueOf(minTemp), Float.valueOf(temp)}).m_130940_(ChatFormatting.AQUA));
                    }
                } else {
                    beeText.m_7220_((Component)Helpers.translatable((String)"firmalife.beehive.no_queen"));
                }
                text.add((Component)beeText);
            }
        });
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{HONEY, BEES}));
    }
}

