/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenBottomBlockEntity;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OvenBottomBlock
extends AbstractOvenBlock
implements IBellowsConsumer {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty LOGS = FLStateProperties.LOGS;

    public OvenBottomBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> curedBlock) {
        super(properties, curedBlock);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LOGS, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41619_() && item.m_204117_(TFCTags.Items.FIREPIT_FUEL)) {
            return FLHelpers.consumeInventory(level, pos, FLBlockEntities.OVEN_BOTTOM, (oven, inv) -> {
                if (inv.getStackInSlot(3).m_41619_()) {
                    return FLHelpers.insertOne(level, item, 3, inv, player);
                }
                return InteractionResult.FAIL;
            });
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            super.m_7100_(state, level, pos, random);
        }
    }

    @Override
    public void cure(Level level, BlockState state, BlockPos pos) {
        if (this.getCured() != null) {
            OvenBottomBlockEntity.cure(level, state, this.getCured().m_49966_(), pos);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return (Boolean)state.m_61143_((Property)LIT) != false && !OvenBottomBlock.insulated(level, currentPos, state) ? (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)) : state;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !OvenBottomBlock.insulated((LevelAccessor)level, pos, state)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIT, LOGS}));
    }

    public void intakeAir(Level level, BlockPos blockPos, BlockState state, int amount) {
        level.m_141902_(blockPos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get()).ifPresent(oven -> oven.onAirIntake(amount));
    }
}

