/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenTopBlockEntity;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OvenTopBlock
extends AbstractOvenBlock {
    public OvenTopBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> curedBlock) {
        super(properties, curedBlock);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack item = player.m_21120_(hand);
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.OVEN_TOP, (oven, inv) -> {
            boolean peel = Helpers.isItem((ItemStack)item, FLTags.Items.USABLE_ON_OVEN);
            if (peel || item.m_41619_() && player.m_6144_()) {
                BlockState downState = level.m_8055_(pos.m_7495_());
                if (!peel && Helpers.isBlock((BlockState)downState, (Block)((Block)FLBlocks.OVEN_BOTTOM.get())) && ((Boolean)downState.m_61143_((Property)OvenBottomBlock.LIT)).booleanValue()) {
                    player.m_6469_(TFCDamageSources.GRILL, 0.5f);
                }
                return FLHelpers.takeOneAny(level, 0, 3, inv, player);
            }
            if (!item.m_41619_()) {
                return FLHelpers.insertOneAny(level, item, 0, 3, inv, player);
            }
            return InteractionResult.PASS;
        });
    }

    @Override
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).map(oven -> oven.getTemperature() > 0.0f).orElse(false).booleanValue()) {
            super.m_7100_(state, level, pos, random);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.extinguish(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        this.extinguish((LevelAccessor)level, pos, state);
    }

    @Override
    public void cure(Level level, BlockState state, BlockPos pos) {
        if (this.getCured() != null) {
            OvenTopBlockEntity.cure(level, state, this.getCured().m_49966_(), pos);
        }
    }

    private void extinguish(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!OvenTopBlock.insulated(level, pos, state)) {
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).ifPresent(OvenTopBlockEntity::extinguish);
        }
    }
}

