/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.util.Mechanics;
import com.mojang.datafixers.util.Either;
import java.util.Random;
import java.util.Set;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ClimateStationBlock
extends DeviceBlock {
    public static final BooleanProperty STASIS = FLStateProperties.STASIS;

    private static void denyAll(Level level, BlockPos pos) {
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.CLIMATE_STATION.get()).ifPresent(station -> station.updateValidity(false, 0));
    }

    @Nullable
    private static Either<Mechanics.GreenhouseInfo, Set<BlockPos>> check(Level level, BlockPos pos, BlockState state) {
        Mechanics.GreenhouseInfo info = Mechanics.getGreenhouse(level, pos, state);
        if (info != null) {
            Set<BlockPos> positions = info.positions();
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.CLIMATE_STATION.get()).ifPresent(station -> {
                station.setPositions(positions);
                station.updateValidity(true, info.type().tier);
                station.setCellar(false);
            });
            ClimateStationBlock.updateState(level, pos, state, true);
            return Either.left((Object)info);
        }
        Set<BlockPos> cellarPositions = Mechanics.getCellar(level, pos, state);
        if (cellarPositions != null) {
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.CLIMATE_STATION.get()).ifPresent(station -> {
                station.setPositions(cellarPositions);
                station.updateValidity(true, 0);
                station.setCellar(true);
            });
            ClimateStationBlock.updateState(level, pos, state, true);
            return Either.right(cellarPositions);
        }
        ClimateStationBlock.denyAll(level, pos);
        ClimateStationBlock.updateState(level, pos, state, false);
        return null;
    }

    private static void updateState(Level level, BlockPos pos, BlockState state, boolean valid) {
        if ((Boolean)state.m_61143_((Property)STASIS) != valid) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STASIS, (Comparable)Boolean.valueOf(valid)));
        }
    }

    public ClimateStationBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STASIS, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Either<Mechanics.GreenhouseInfo, Set<BlockPos>> either = ClimateStationBlock.check(level, pos, state);
        if (either == null) {
            return InteractionResult.PASS;
        }
        either.ifLeft(info -> player.m_5661_((Component)new TranslatableComponent("firmalife.greenhouse.found", new Object[]{info.positions().size()}), true));
        either.ifRight(positions -> player.m_5661_((Component)new TranslatableComponent("firmalife.cellar.found", new Object[]{positions.size()}), true));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (random.nextInt(5) == 0) {
            super.m_7455_(state, level, pos, random);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        ClimateStationBlock.check((Level)level, pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        ClimateStationBlock.denyAll(level, pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STASIS});
    }
}

