/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseDoorBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseSlabBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseStairBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseWallBlock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public enum Greenhouse {
    RUSTED_IRON(SoundType.f_56743_, false),
    IRON(SoundType.f_56743_, false, RUSTED_IRON),
    OXIDIZED_COPPER(SoundType.f_154663_, false),
    WEATHERED_COPPER(SoundType.f_154663_, false, OXIDIZED_COPPER),
    EXPOSED_COPPER(SoundType.f_154663_, false, WEATHERED_COPPER),
    COPPER(SoundType.f_154663_, false, EXPOSED_COPPER),
    WEATHERED_TREATED_WOOD(SoundType.f_56736_, true),
    TREATED_WOOD(SoundType.f_56736_, true, WEATHERED_TREATED_WOOD),
    STAINLESS_STEEL(SoundType.f_56762_, false);

    @Nullable
    private final Greenhouse next;
    private final SoundType sound;
    private final boolean flammable;

    private Greenhouse(SoundType sound, boolean flammable) {
        this.next = null;
        this.sound = sound;
        this.flammable = flammable;
    }

    private Greenhouse(SoundType sound, boolean flammable, Greenhouse next) {
        this.next = next;
        this.sound = sound;
        this.flammable = flammable;
    }

    public static enum BlockType {
        WALL((green, type) -> new GreenhouseWallBlock(BlockType.properties(green), type.getNext((Greenhouse)((Object)green)))),
        ROOF((green, type) -> new GreenhouseStairBlock(BlockType.properties(green), () -> ((Block)FLBlocks.GREENHOUSE_BLOCKS.get(green).get((Object)WALL).get()).m_49966_(), type.getNext((Greenhouse)((Object)green)))),
        ROOF_TOP((green, type) -> new GreenhouseSlabBlock(BlockType.properties(green), type.getNext((Greenhouse)((Object)green)))),
        DOOR((green, type) -> new GreenhouseDoorBlock(BlockType.properties(green), type.getNext((Greenhouse)((Object)green))));

        private final BiFunction<Greenhouse, BlockType, ? extends Block> factory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;

        public static ExtendedProperties properties(Greenhouse green) {
            ExtendedProperties prop = ExtendedProperties.of((BlockBehaviour.Properties)BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(green.sound).m_60978_(4.0f).m_60955_().m_60977_());
            if (green.flammable) {
                prop = prop.flammable(60, 30);
            }
            return prop;
        }

        private BlockType(BiFunction<Greenhouse, BlockType, ? extends Block> factory) {
            this(factory, BlockItem::new);
        }

        private BlockType(BiFunction<Greenhouse, BlockType, ? extends Block> factory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.factory = factory;
            this.blockItemFactory = blockItemFactory;
        }

        public Supplier<Block> create(Greenhouse type) {
            return () -> this.factory.apply(type, this);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        @Nullable
        public Supplier<? extends Block> getNext(Greenhouse green) {
            return green.next == null ? null : (Supplier)FLBlocks.GREENHOUSE_BLOCKS.get((Object)green.next).get((Object)this);
        }
    }
}

