/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.client.FLClientHelpers;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PlanterType;
import com.eerussianguy.firmalife.common.util.Mechanics;
import com.eerussianguy.firmalife.common.util.Plantable;
import java.util.List;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class LargePlanterBlock
extends DeviceBlock
implements HoeOverlayBlock {
    public static final BooleanProperty WATERED = FLStateProperties.WATERED;
    private static final VoxelShape LARGE_SHAPE = LargePlanterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public LargePlanterBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        Plantable plant = Plantable.get(held);
        Fertilizer fertilizer = Fertilizer.get((ItemStack)held);
        int slot = this.getUseSlot(hit, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargePlanterBlockEntity) {
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            if (!held.m_41619_() && fertilizer != null) {
                planter.addNutrients(fertilizer);
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    Mechanics.addNutrientParticles(server, pos, fertilizer);
                }
                held.m_41774_(1);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (plant != null) {
                if (plant.getPlanterType() != this.getPlanterType()) {
                    player.m_5661_((Component)new TranslatableComponent("firmalife.greenhouse.wrong_type").m_130946_(FLHelpers.getEnumTranslationKey(plant.getPlanterType())), true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (planter.getTier() < plant.getTier()) {
                    if (!planter.isClimateValid()) {
                        player.m_5661_((Component)new TranslatableComponent("firmalife.greenhouse.climate_invalid"), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("firmalife.greenhouse.wrong_tier"), true);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return this.insertSlot(level, planter, held, player, slot);
            }
            if (player.m_6144_() && held.m_41619_()) {
                return this.takeSlot(level, planter, player, slot);
            }
        }
        return InteractionResult.PASS;
    }

    public PlanterType getPlanterType() {
        return PlanterType.LARGE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        for (Direction d : Helpers.DIRECTIONS) {
            LargePlanterBlockEntity planter;
            BlockPos rel = pos.m_142300_(d);
            BlockEntity blockEntity = level.m_7702_(rel);
            if (!(blockEntity instanceof LargePlanterBlockEntity) || !(planter = (LargePlanterBlockEntity)blockEntity).checkValid()) continue;
            planter.setValid(level, rel, true, planter.getTier(), false);
        }
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean debug) {
        if (!level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargePlanterBlockEntity) {
            boolean valid;
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            BlockHitResult target = FLClientHelpers.getTargetedLocation();
            if (target == null) {
                return;
            }
            int slot = this.getUseSlot(target, pos);
            text.add((Component)new TranslatableComponent("firmalife.planter.growth_water", new Object[]{String.format("%.2f", Float.valueOf(planter.getGrowth(slot))), String.format("%.2f", Float.valueOf(planter.getWater()))}));
            if (planter.getGrowth(slot) >= 1.0f) {
                text.add((Component)new TranslatableComponent("tfc.tooltip.farmland.mature"));
            }
            text.add((Component)new TranslatableComponent((valid = planter.checkValid()) ? "firmalife.greenhouse.valid_block" : "firmalife.greenhouse.invalid_block"));
            if (!valid) {
                text.add(planter.getInvalidReason());
            }
            text.add((Component)new TranslatableComponent("tfc.tooltip.farmland.nutrients", new Object[]{this.format(planter, FarmlandBlockEntity.NutrientType.NITROGEN), this.format(planter, FarmlandBlockEntity.NutrientType.PHOSPHOROUS), this.format(planter, FarmlandBlockEntity.NutrientType.POTASSIUM)}));
        }
    }

    private String format(LargePlanterBlockEntity planter, FarmlandBlockEntity.NutrientType value) {
        return String.format("%.2f", Float.valueOf(planter.getNutrient(value) * 100.0f));
    }

    protected int getUseSlot(BlockHitResult hit, BlockPos pos) {
        return 0;
    }

    public InteractionResult insertSlot(Level level, LargePlanterBlockEntity planter, ItemStack held, Player player, int slot) {
        return planter.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> {
            InteractionResult res = InteractionResult.PASS;
            if (inv.getStackInSlot(slot).m_41619_() && (res = FLHelpers.insertOne(level, held, slot, inv, player)).m_19077_()) {
                planter.setGrowth(slot, 0.0f);
                planter.updateCache();
            }
            return res;
        }).orElse(InteractionResult.PASS);
    }

    public InteractionResult takeSlot(Level level, LargePlanterBlockEntity planter, Player player, int slot) {
        return planter.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> {
            Plantable plant = planter.getPlantable(slot);
            if (plant != null && planter.getGrowth(slot) >= 1.0f) {
                if (this.resetGrowthTo() == 0.0f) {
                    inv.extractItem(slot, 1, false);
                }
                int seedAmount = level.f_46441_.nextFloat() < plant.getExtraSeedChance() ? 2 : 1;
                ItemStack seed = plant.getSeed();
                if (!seed.m_41619_()) {
                    seed.m_41764_(seedAmount);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)seed);
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)plant.getCrop());
                planter.setGrowth(slot, this.resetGrowthTo());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    protected float resetGrowthTo() {
        return 0.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LARGE_SHAPE;
    }
}

