/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.capabilities.bee;

import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.INBTSerializable;

public interface IBee
extends INBTSerializable<CompoundTag> {
    public void setHasQueen(boolean var1);

    public boolean hasQueen();

    public int[] getAbilityMap();

    public void setAbilities(int[] var1);

    public void setAbility(BeeAbility var1, int var2);

    default public int getAbility(BeeAbility ability) {
        return this.getAbilityMap()[ability.ordinal()];
    }

    default public void initFreshAbilities(Random random) {
        int[] values = BeeAbility.fresh();
        values[random.nextInt((int)values.length)] = random.nextInt(4) + 1;
        values[random.nextInt((int)values.length)] = random.nextInt(4) + 1;
        if (random.nextFloat() < 0.1f) {
            values[random.nextInt((int)values.length)] = random.nextInt(4) + 1;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = random.nextInt(4) + 1;
        }
        this.setAbilities(values);
        this.setHasQueen(true);
    }

    default public void setAbilitiesFromParents(IBee parent1, IBee parent2, Random random) {
        int[] parent1Abilities = parent1.getAbilityMap();
        int[] parent2Abilities = parent2.getAbilityMap();
        int mutation = (parent1Abilities[BeeAbility.MUTANT.ordinal()] + parent2Abilities[BeeAbility.MUTANT.ordinal()]) / 2;
        mutation = Mth.m_14045_((int)mutation, (int)1, (int)5);
        for (BeeAbility ability : BeeAbility.VALUES) {
            int average = (parent1Abilities[ability.ordinal()] + parent2Abilities[ability.ordinal()]) / 2;
            if (average < 1) continue;
            this.setAbility(ability, Mth.m_14072_((Random)random, (int)(average - mutation), (int)(average + mutation)));
        }
        this.setHasQueen(true);
    }

    default public void addTooltipInfo(List<Component> tooltip) {
        if (this.hasQueen()) {
            tooltip.add((Component)new TranslatableComponent("firmalife.bee.queen").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)new TranslatableComponent("firmalife.bee.abilities").m_130940_(ChatFormatting.WHITE));
            for (BeeAbility ability : BeeAbility.VALUES) {
                int amount = this.getAbility(ability);
                if (amount <= 0) continue;
                tooltip.add((Component)new TranslatableComponent("firmalife.bee.ability." + ability.m_7912_(), new Object[]{String.valueOf(amount)}).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("firmalife.bee.no_queen").m_130940_(ChatFormatting.RED));
        }
    }
}

