/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.items.BeehiveFrameItem;
import com.eerussianguy.firmalife.common.items.FLFood;
import com.eerussianguy.firmalife.common.items.SeedBallItem;
import com.eerussianguy.firmalife.common.items.Spice;
import com.eerussianguy.firmalife.common.items.WateringCanItem;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.FLFruit;
import com.eerussianguy.firmalife.common.util.FLMetal;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.DecayingItem;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.SandwichItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FLItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"firmalife");
    public static final EnumSet<Food> TFC_FRUITS = EnumSet.of(Food.BANANA, new Food[]{Food.BLACKBERRY, Food.BLUEBERRY, Food.BUNCHBERRY, Food.CHERRY, Food.CLOUDBERRY, Food.CRANBERRY, Food.ELDERBERRY, Food.GOOSEBERRY, Food.GREEN_APPLE, Food.LEMON, Food.OLIVE, Food.ORANGE, Food.PEACH, Food.PLUM, Food.RASPBERRY, Food.RED_APPLE, Food.SNOWBERRY, Food.STRAWBERRY, Food.WINTERGREEN_BERRY});
    public static final RegistryObject<Item> BEEHIVE_FRAME = FLItems.register("beehive_frame", () -> new BeehiveFrameItem(FLItems.prop()));
    public static final RegistryObject<Item> BEESWAX = FLItems.register("beeswax", TFCItemGroup.MISC);
    public static final RegistryObject<Item> CINNAMON_BARK = FLItems.register("cinnamon_bark", TFCItemGroup.MISC);
    public static final RegistryObject<Item> CHEESECLOTH = FLItems.register("cheesecloth", TFCItemGroup.MISC);
    public static final RegistryObject<Item> FRUIT_LEAF = FLItems.register("fruit_leaf", TFCItemGroup.MISC);
    public static final RegistryObject<Item> EMPTY_JAR = FLItems.register("empty_jar", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PEEL = FLItems.register("peel", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PIE_PAN = FLItems.register("pie_pan", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PINEAPPLE_LEATHER = FLItems.register("pineapple_leather", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PINEAPPLE_YARN = FLItems.register("pineapple_yarn", TFCItemGroup.MISC);
    public static final RegistryObject<Item> RAW_HONEY = FLItems.register("raw_honey", TFCItemGroup.MISC);
    public static final RegistryObject<Item> RENNET = FLItems.register("rennet", TFCItemGroup.MISC);
    public static final RegistryObject<Item> SEED_BALL = FLItems.register("seed_ball", () -> new SeedBallItem(FLItems.prop()));
    public static final RegistryObject<Item> SPOON = FLItems.register("spoon", TFCItemGroup.MISC);
    public static final RegistryObject<Item> TREATED_LUMBER = FLItems.register("treated_lumber", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WATERING_CAN = FLItems.register("watering_can", () -> new WateringCanItem(FLItems.prop()));
    public static final Map<Spice, RegistryObject<Item>> SPICES = Helpers.mapOfKeys(Spice.class, spice -> FLItems.register("spice/" + spice.name(), TFCItemGroup.MISC));
    public static final Map<FLFood, RegistryObject<Item>> FOODS = Helpers.mapOfKeys(FLFood.class, food -> FLItems.register("food/" + food.name(), () -> new DecayingItem(new Item.Properties().m_41489_(food.getFoodProperties()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<FLFruit, RegistryObject<Item>> FRUITS = Helpers.mapOfKeys(FLFruit.class, food -> FLItems.register("food/" + food.name(), () -> new DecayingItem(new Item.Properties().m_41489_(food.getFoodProperties()).m_41491_(TFCItemGroup.FOOD))));
    public static final RegistryObject<DynamicBowlFood> FILLED_PIE = FLItems.registerContainerFood("food/filled_pie", false);
    public static final RegistryObject<DynamicBowlFood> COOKED_PIE = FLItems.registerContainerFood("food/cooked_pie");
    public static final RegistryObject<SandwichItem> RAW_PIZZA = FLItems.registerDynamicFood("food/raw_pizza", false);
    public static final RegistryObject<SandwichItem> COOKED_PIZZA = FLItems.registerDynamicFood("food/cooked_pizza");
    public static final Map<Ore.Grade, RegistryObject<Item>> CHROMIUM_ORES = Helpers.mapOfKeys(Ore.Grade.class, grade -> FLItems.register("ore/" + grade.name() + "_chromite", TFCItemGroup.ORES));
    public static final Map<FLMetal, Map<FLMetal.ItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(FLMetal.class, metal -> Helpers.mapOfKeys(FLMetal.ItemType.class, type -> FLItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((FLMetal)((Object)metal)))));
    public static final Map<FLMetal, RegistryObject<BucketItem>> METAL_FLUID_BUCKETS = Helpers.mapOfKeys(FLMetal.class, metal -> FLItems.register("bucket/metal/" + metal.name(), () -> new BucketItem((Supplier)FLFluids.METALS.get(metal).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC))));
    public static final Map<ExtraFluid, RegistryObject<BucketItem>> EXTRA_FLUID_BUCKETS = Helpers.mapOfKeys(ExtraFluid.class, fluid -> FLItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)FLFluids.EXTRA_FLUIDS.get(fluid).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC))));

    private static Item.Properties prop() {
        return new Item.Properties().m_41491_(TFCItemGroup.MISC);
    }

    private static RegistryObject<SandwichItem> registerDynamicFood(String name) {
        return FLItems.registerDynamicFood(name, true);
    }

    private static RegistryObject<SandwichItem> registerDynamicFood(String name, boolean edible) {
        return FLItems.register(name, () -> new SandwichItem(FLItems.foodProperties(edible)));
    }

    private static RegistryObject<DynamicBowlFood> registerContainerFood(String name) {
        return FLItems.registerContainerFood(name, true);
    }

    private static RegistryObject<DynamicBowlFood> registerContainerFood(String name, boolean edible) {
        return FLItems.register(name, () -> new DynamicBowlFood(FLItems.foodProperties(edible)));
    }

    private static Item.Properties foodProperties(boolean edible) {
        Item.Properties properties = new Item.Properties().m_41491_(TFCItemGroup.FOOD);
        if (edible) {
            properties.m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_());
        }
        return properties;
    }

    private static RegistryObject<Item> register(String name, CreativeModeTab group) {
        return FLItems.register(name, () -> new Item(new Item.Properties().m_41491_(group)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

