/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GreenhouseType {
    public static final DataManager<GreenhouseType> MANAGER = new DataManager(FLHelpers.identifier("greenhouse"), "greenhouse", GreenhouseType::new, GreenhouseType::new, GreenhouseType::encode, Packet::new);
    public static final IndirectHashCollection<Block, GreenhouseType> CACHE = IndirectHashCollection.create(s -> s.ingredient.getValidBlocks(), () -> MANAGER.getValues());
    public final ResourceLocation id;
    public final BlockIngredient ingredient;
    public final int tier;

    @Nullable
    public static GreenhouseType get(BlockState state) {
        for (GreenhouseType def : CACHE.getAll((Object)state.m_60734_())) {
            if (!def.ingredient.test(state)) continue;
            return def;
        }
        return null;
    }

    @Nullable
    public static GreenhouseType get(ResourceLocation id) {
        for (GreenhouseType def : MANAGER.getValues()) {
            if (def.id != id) continue;
            return def;
        }
        return null;
    }

    private GreenhouseType(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.ingredient = BlockIngredients.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient"));
        this.tier = JsonHelpers.m_13927_((JsonObject)json, (String)"tier");
    }

    private GreenhouseType(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.ingredient = BlockIngredients.fromNetwork((FriendlyByteBuf)buffer);
        this.tier = buffer.m_130242_();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.toNetwork(buffer);
        buffer.m_130130_(this.tier);
    }

    public static class Packet
    extends DataManagerSyncPacket<GreenhouseType> {
    }
}

