/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Plantable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;

public final class Mechanics {
    private static final BlockIngredient CELLAR = BlockIngredients.of(FLTags.Blocks.CELLAR_INSULATION);
    private static final int UPDATE_INTERVAL = 24000;
    public static final float GROWTH_FACTOR = 2.6041666E-6f;
    public static final float NUTRIENT_CONSUMPTION = 5.2083333E-6f;
    public static final float WATER_CONSUMPTION = 3.4722223E-6f;
    public static final float NUTRIENT_GROWTH_FACTOR = 0.5f;

    public static Set<BlockPos> floodfill(Level level, BlockPos startPos, BlockPos.MutableBlockPos mutable, BoundingBox bounds, Predicate<BlockState> wallPredicate, Predicate<BlockState> interiorPredicate, boolean testOrigin, int lastSize, Direction[] checkDirections) {
        if (testOrigin && !wallPredicate.test(level.m_8055_(startPos))) {
            return Collections.emptySet();
        }
        int maxSize = bounds.m_71056_() * bounds.m_71057_() * bounds.m_71058_();
        HashSet<BlockPos> filled = lastSize == -1 ? new HashSet<BlockPos>() : new HashSet(lastSize);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        filled.add(startPos);
        queue.addFirst(startPos);
        while (!queue.isEmpty()) {
            if (filled.size() > maxSize) {
                return Collections.emptySet();
            }
            BlockPos testPos = (BlockPos)queue.removeFirst();
            for (Direction direction : checkDirections) {
                BlockState stateAt;
                mutable.m_122190_((Vec3i)testPos).m_122173_(direction);
                if (filled.contains(mutable) || wallPredicate.test(stateAt = level.m_8055_((BlockPos)mutable))) continue;
                if (interiorPredicate.test(stateAt)) {
                    if (!bounds.m_71051_((Vec3i)mutable)) {
                        return Collections.emptySet();
                    }
                    BlockPos posNext = mutable.m_7949_();
                    queue.addFirst(posNext);
                    filled.add(posNext);
                    continue;
                }
                return Collections.emptySet();
            }
        }
        return filled;
    }

    @Nullable
    public static Set<BlockPos> getCellar(Level level, BlockPos pos, BlockState state) {
        return Mechanics.getCellar(level, pos, state, -1);
    }

    @Nullable
    public static Set<BlockPos> getCellar(Level level, BlockPos pos, BlockState state, int lastSize) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Helpers.DIRECTIONS) {
            mutable.m_122159_((Vec3i)pos, d);
            if (!CELLAR.test(level.m_8055_((BlockPos)mutable))) continue;
            BoundingBox box = new BoundingBox(pos).m_191961_(15);
            Set<BlockPos> filled = Mechanics.floodfill(level, pos, mutable, box, (Predicate<BlockState>)CELLAR, s -> !Helpers.isBlock((BlockState)s, (Block)((Block)FLBlocks.CLIMATE_STATION.get())), false, lastSize, Helpers.DIRECTIONS);
            return filled.isEmpty() ? null : filled;
        }
        return null;
    }

    @Nullable
    public static GreenhouseInfo getGreenhouse(Level level, BlockPos pos, BlockState state) {
        return Mechanics.getGreenhouse(level, pos, state, -1);
    }

    @Nullable
    public static GreenhouseInfo getGreenhouse(Level level, BlockPos pos, BlockState state, int lastSize) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Helpers.DIRECTIONS) {
            mutable.m_122159_((Vec3i)pos, d);
            GreenhouseType greenhouse = GreenhouseType.get(level.m_8055_((BlockPos)mutable));
            if (greenhouse == null) continue;
            BoundingBox box = new BoundingBox(pos).m_191961_(15);
            Set<BlockPos> filled = Mechanics.floodfill(level, pos, mutable, box, (Predicate<BlockState>)greenhouse.ingredient, s -> !Helpers.isBlock((BlockState)s, (Block)((Block)FLBlocks.CLIMATE_STATION.get())), false, lastSize, FLHelpers.NOT_DOWN);
            if (filled.isEmpty()) {
                return null;
            }
            return new GreenhouseInfo(greenhouse, filled);
        }
        return null;
    }

    public static boolean growthTick(Level level, BlockPos pos, BlockState state, LargePlanterBlockEntity planter) {
        long firstTick = planter.getLastUpdateTick();
        long thisTick = Calendars.SERVER.getTicks();
        long lastTick = firstTick;
        for (long tick = firstTick + 24000L; tick < thisTick; tick += 24000L) {
            if (!Mechanics.growthTickStep(level, level.m_5822_(), lastTick, tick, planter)) {
                return false;
            }
            lastTick = tick;
        }
        return lastTick >= thisTick || Mechanics.growthTickStep(level, level.m_5822_(), lastTick, thisTick, planter);
    }

    public static boolean growthTickStep(Level level, Random random, long fromTick, long toTick, LargePlanterBlockEntity planter) {
        ICalendar calendar = Calendars.get((LevelReader)level);
        long tickDelta = toTick - fromTick;
        boolean growing = planter.checkValid();
        for (int slot = 0; slot < planter.slots(); ++slot) {
            Plantable plant = planter.getPlantable(slot);
            if (plant != null) {
                float nutrientsConsumed = planter.consumeNutrientAndResupplyOthers(plant.getPrimaryNutrient(), 5.2083333E-6f * (float)tickDelta);
                float totalGrowthDelta = Helpers.uniform((Random)random, (float)0.9f, (float)1.1f) * (float)tickDelta * 2.6041666E-6f + nutrientsConsumed * 0.5f;
                float growth = planter.getGrowth(slot);
                if (totalGrowthDelta > 0.0f && growing) {
                    float delta = Mth.m_14036_((float)totalGrowthDelta, (float)0.0f, (float)1.0f);
                    growth += delta;
                    planter.drainWater((float)tickDelta * 3.4722223E-6f);
                }
                planter.setGrowth(slot, Mth.m_14036_((float)growth, (float)0.0f, (float)1.0f));
                continue;
            }
            planter.setGrowth(slot, 0.0f);
        }
        planter.setLastUpdateTick(calendar.getTicks());
        planter.markForSync();
        planter.afterGrowthTickStep(growing);
        return true;
    }

    public static void addNutrientParticles(ServerLevel level, BlockPos pos, Fertilizer fertilizer) {
        int i;
        float n = fertilizer.getNitrogen();
        float p = fertilizer.getPhosphorus();
        float k = fertilizer.getPotassium();
        for (i = 0; i < (int)(n > 0.0f ? Mth.m_14036_((float)(n * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.NITROGEN.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123342_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(p > 0.0f ? Mth.m_14036_((float)(p * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.PHOSPHORUS.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123342_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(k > 0.0f ? Mth.m_14036_((float)(k * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.POTASSIUM.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123342_() + level.f_46441_.nextFloat()), (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public record GreenhouseInfo(GreenhouseType type, Set<BlockPos> positions) {
    }
}

