/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PlanterType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class Plantable
extends ItemDefinition {
    public static final DataManager<Plantable> MANAGER = new DataManager(FLHelpers.identifier("plantable"), "plantable", Plantable::new, Plantable::new, Plantable::encode, Packet::new);
    public static final IndirectHashCollection<Item, Plantable> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, () -> MANAGER.getValues());
    private final PlanterType planter;
    private final int tier;
    private final int stages;
    private final float extraSeedChance;
    private final ItemStack seed;
    private final ItemStack crop;
    private final FarmlandBlockEntity.NutrientType nutrient;
    private final String texture;

    @Nullable
    public static Plantable get(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Plantable def : CACHE.getAll((Object)stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    @Nullable
    public static Plantable get(ResourceLocation id) {
        for (Plantable def : MANAGER.getValues()) {
            if (def.id != id) continue;
            return def;
        }
        return null;
    }

    private Plantable(ResourceLocation id, JsonObject json) {
        super(id, Ingredient.m_43917_((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient")));
        this.planter = (PlanterType)JsonHelpers.getEnum((JsonObject)json, (String)"planter", PlanterType.class, (Enum)PlanterType.QUAD);
        this.tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)0);
        this.stages = JsonHelpers.m_13824_((JsonObject)json, (String)"stages", (int)0);
        this.extraSeedChance = JsonHelpers.m_13820_((JsonObject)json, (String)"extra_seed_chance", (float)0.5f);
        this.seed = json.has("seed") ? JsonHelpers.getItemStack((JsonObject)json, (String)"seed") : ItemStack.f_41583_;
        this.crop = JsonHelpers.getItemStack((JsonObject)json, (String)"crop");
        this.nutrient = (FarmlandBlockEntity.NutrientType)JsonHelpers.getEnum((JsonObject)json, (String)"nutrient", FarmlandBlockEntity.NutrientType.class, (Enum)FarmlandBlockEntity.NutrientType.NITROGEN);
        this.texture = JsonHelpers.m_13906_((JsonObject)json, (String)"texture");
    }

    private Plantable(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.planter = (PlanterType)buffer.m_130066_(PlanterType.class);
        this.tier = buffer.m_130242_();
        this.stages = buffer.m_130242_();
        this.extraSeedChance = buffer.readFloat();
        this.seed = buffer.m_130267_();
        this.crop = buffer.m_130267_();
        this.nutrient = (FarmlandBlockEntity.NutrientType)buffer.m_130066_(FarmlandBlockEntity.NutrientType.class);
        this.texture = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130068_((Enum)this.planter);
        buffer.m_130130_(this.tier);
        buffer.m_130130_(this.stages);
        buffer.writeFloat(this.extraSeedChance);
        buffer.m_130055_(this.seed);
        buffer.m_130055_(this.crop);
        buffer.m_130068_((Enum)this.nutrient);
        buffer.m_130070_(this.texture);
    }

    public PlanterType getPlanterType() {
        return this.planter;
    }

    public int getStages() {
        return this.stages;
    }

    public ItemStack getSeed() {
        return this.seed.m_41777_();
    }

    public ItemStack getCrop() {
        return this.crop.m_41777_();
    }

    public FarmlandBlockEntity.NutrientType getPrimaryNutrient() {
        return this.nutrient;
    }

    public int getTier() {
        return this.tier;
    }

    public String getTextureLocation() {
        return this.texture;
    }

    public float getExtraSeedChance() {
        return this.extraSeedChance;
    }

    public ResourceLocation getTexture(float growth) {
        return new ResourceLocation(this.texture + "_" + (int)(growth * (float)this.stages));
    }

    public static class Packet
    extends DataManagerSyncPacket<Plantable> {
    }
}

