/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.formats.glyph.GlyphVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.ExtendedQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.system.MemoryUtil;

public class EntityVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements QuadVertexSink,
GlyphVertexSink {
    private static final int STRIDE = IrisVertexFormats.ENTITY.m_86020_();
    private final QuadViewEntity.QuadViewEntityUnsafe quad = new QuadViewEntity.QuadViewEntityUnsafe();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;
    private float uSum;
    private float vSum;

    public EntityVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)ExtendedQuadVertexType.INSTANCE);
    }

    public void writeQuad(float x, float y, float z, int color, float u, float v, int light, int overlay, int normal) {
        long i = this.writePointer;
        ++this.vertexCount;
        this.uSum += u;
        this.vSum += v;
        MemoryUtil.memPutFloat((long)i, (float)x);
        MemoryUtil.memPutFloat((long)(i + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(i + 8L), (float)z);
        MemoryUtil.memPutInt((long)(i + 12L), (int)color);
        MemoryUtil.memPutFloat((long)(i + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(i + 20L), (float)v);
        MemoryUtil.memPutInt((long)(i + 24L), (int)overlay);
        MemoryUtil.memPutInt((long)(i + 28L), (int)light);
        MemoryUtil.memPutShort((long)(i + 36L), (short)-1);
        MemoryUtil.memPutShort((long)(i + 38L), (short)-1);
        if (this.vertexCount == 4) {
            this.endQuad(normal);
        }
        this.advance();
    }

    public void writeGlyph(float x, float y, float z, int color, float u, float v, int light) {
        this.writeQuad(x, y, z, color, u, v, light, OverlayTexture.f_118083_, 0);
    }

    private void endQuad(int normal) {
        float normalZ;
        float normalY;
        float normalX;
        this.vertexCount = 0;
        long i = this.writePointer;
        this.uSum = (float)((double)this.uSum * 0.25);
        this.vSum = (float)((double)this.vSum * 0.25);
        this.quad.setup(this.writePointer, STRIDE);
        if (normal == 0) {
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            normalX = this.saveNormal.x;
            normalY = this.saveNormal.y;
            normalZ = this.saveNormal.z;
            normal = NormalHelper.packNormal(this.saveNormal, 0.0f);
        } else {
            normalX = Norm3b.unpackX((int)normal);
            normalY = Norm3b.unpackY((int)normal);
            normalZ = Norm3b.unpackZ((int)normal);
        }
        int tangent = NormalHelper.computeTangent(normalX, normalY, normalZ, this.quad);
        for (long vertex = 0L; vertex < 4L; ++vertex) {
            MemoryUtil.memPutFloat((long)(i + 40L - (long)STRIDE * vertex), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 44L - (long)STRIDE * vertex), (float)this.vSum);
            MemoryUtil.memPutInt((long)(i + 32L - (long)STRIDE * vertex), (int)normal);
            MemoryUtil.memPutInt((long)(i + 48L - (long)STRIDE * vertex), (int)tangent);
        }
        this.uSum = 0.0f;
        this.vSum = 0.0f;
    }
}

