/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.type.BlittableVertexType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisChunkMeshAttributes;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisGlVertexAttributeFormat;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexBufferWriterNio;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexBufferWriterUnsafe;

public class XHFPModelVertexType
implements ChunkVertexType {
    public static final int STRIDE = 40;
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, (int)40).addElement((Enum)ChunkMeshAttribute.POSITION_ID, 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false).addElement((Enum)ChunkMeshAttribute.COLOR, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true).addElement((Enum)ChunkMeshAttribute.BLOCK_TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false).addElement((Enum)ChunkMeshAttribute.LIGHT_TEXTURE, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, true).addElement((Enum)IrisChunkMeshAttributes.MID_TEX_COORD, 20, GlVertexAttributeFormat.FLOAT, 2, false).addElement((Enum)IrisChunkMeshAttributes.TANGENT, 28, IrisGlVertexAttributeFormat.BYTE, 4, true).addElement((Enum)IrisChunkMeshAttributes.NORMAL, 32, IrisGlVertexAttributeFormat.BYTE, 3, true).addElement((Enum)IrisChunkMeshAttributes.BLOCK_ID, 36, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false).build();
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 65536;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 1.5258789E-5f;

    public ModelVertexSink createFallbackWriter(VertexConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    public ModelVertexSink createBufferWriter(VertexBufferView buffer, boolean direct) {
        return direct ? new XHFPModelVertexBufferWriterUnsafe(buffer) : new XHFPModelVertexBufferWriterNio(buffer);
    }

    public BlittableVertexType<ModelVertexSink> asBlittable() {
        return this;
    }

    public GlVertexFormat<ChunkMeshAttribute> getCustomVertexFormat() {
        return VERTEX_FORMAT;
    }

    public float getTextureScale() {
        return 1.5258789E-5f;
    }

    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    public float getPositionOffset() {
        return -8.0f;
    }

    static short encodeBlockTexture(float value) {
        return (short)(value * 65536.0f);
    }

    static float decodeBlockTexture(short raw) {
        return (float)(raw & 0xFFFF) * 1.5258789E-5f;
    }

    static short encodePosition(float v) {
        return (short)((8.0f + v) * 2048.0f);
    }

    static float decodePosition(short raw) {
        return (float)(raw & 0xFFFF) * 4.8828125E-4f - 8.0f;
    }

    static int encodeLightMapTexCoord(int light) {
        int r = light;
        r &= 0xFF00FF;
        r <<= 8;
        return r += 0x8000800;
    }
}

