/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;

public class FloatUniform
extends Uniform {
    private float cachedValue = 0.0f;
    private final FloatSupplier value;

    FloatUniform(int location, FloatSupplier value) {
        this(location, value, null);
    }

    FloatUniform(int location, FloatSupplier value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        float newValue = this.value.getAsFloat();
        if (this.cachedValue != newValue) {
            this.cachedValue = newValue;
            IrisRenderSystem.uniform1f(this.location, newValue);
        }
    }
}

