/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.coderbot.batchedentityrendering.impl.BatchingDebugMessageHelper;
import net.coderbot.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.RenderBuffersExt;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.Matrix4fAccess;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.FrustumHolder;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ShadowRenderer {
    public static boolean ACTIVE = false;
    public static List<BlockEntity> visibleBlockEntities;
    private final float halfPlaneLength;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    public static Matrix4f MODELVIEW;
    private final ShadowRenderTargets targets;
    private final OptionalBoolean packCullingState;
    private final boolean packHasVoxelization;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final float sunPathRotation;
    private final RenderBuffers buffers;
    private final RenderBuffersExt renderBuffersExt;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowBlockEntities = 0;

    public ShadowRenderer(ProgramSource shadow, PackDirectives directives, ShadowRenderTargets shadowRenderTargets, boolean shadowUsesImages) {
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = shadowDirectives.getEntityShadowDistanceMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities();
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = shadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (shadow != null) {
            this.packHasVoxelization = shadow.getGeometrySource().isPresent() || shadowUsesImages;
            this.packCullingState = shadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = OptionalBoolean.DEFAULT;
        }
        this.sunPathRotation = directives.getSunPathRotation();
        this.buffers = new RenderBuffers();
        this.renderBuffersExt = this.buffers instanceof RenderBuffersExt ? (RenderBuffersExt)this.buffers : null;
        this.configureSamplingSettings(shadowDirectives);
    }

    public static PoseStack createShadowModelView(float sunPathRotation, float intervalSize) {
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        PoseStack modelView = new PoseStack();
        ShadowMatrices.createModelViewMatrix(modelView.m_85850_().m_85861_(), ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, cameraX, cameraY, cameraZ);
        return modelView;
    }

    private static ClientLevel getLevel() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    private static float getSkyAngle() {
        return ShadowRenderer.getLevel().m_46942_(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float skyAngle = ShadowRenderer.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        RenderSystem.m_69388_((int)33988);
        RenderSystem.m_69396_((int)this.targets.getDepthTexture().getTextureId());
        this.configureDepthSampler(this.targets.getDepthTexture().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        RenderSystem.m_69396_((int)this.targets.getDepthTextureNoTranslucents().getTextureId());
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < colorSamplingSettings.size(); ++i) {
            int glTextureId = this.targets.getColorTextureId(i);
            RenderSystem.m_69396_((int)glTextureId);
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.get(i));
        }
        RenderSystem.m_69396_((int)0);
        RenderSystem.m_69388_((int)33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering()) {
            RenderSystem.m_69937_((int)3553, (int)34892, (int)34894);
        }
        IrisRenderSystem.texParameteriv(3553, 36422, new int[]{6403, 6403, 6403, 1});
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
            RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        } else {
            RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
            RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
        }
    }

    private void generateMipmaps() {
        RenderSystem.m_69388_((int)33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            RenderSystem.m_69396_((int)mipmapPass.getTexture());
            this.setupMipmappingForBoundTexture(mipmapPass.getTargetFilteringMode());
        }
        RenderSystem.m_69396_((int)0);
        RenderSystem.m_69388_((int)33984);
    }

    private void setupMipmappingForBoundTexture(int filteringMode) {
        IrisRenderSystem.generateMipmaps(3553);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)filteringMode);
    }

    private FrustumHolder createShadowFrustum(float renderMultiplier, FrustumHolder holder) {
        String reason;
        double distance;
        if ((this.packCullingState == OptionalBoolean.FALSE || this.packHasVoxelization) && this.packCullingState != OptionalBoolean.TRUE) {
            distance = this.halfPlaneLength * renderMultiplier;
            reason = this.packCullingState == OptionalBoolean.FALSE ? "(set by shader pack)" : "(voxelization detected)";
            if (distance <= 0.0 || distance > (double)(Minecraft.m_91087_().f_91066_.m_193772_() * 16)) {
                String distanceInfo = "render distance = " + Minecraft.m_91087_().f_91066_.m_193772_() * 16 + " blocks ";
                distanceInfo = distanceInfo + (Minecraft.m_91087_().m_91090_() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                String cullingInfo = "disabled " + reason;
                return holder.setInfo(new NonCullingFrustum(), distanceInfo, cullingInfo);
            }
        } else {
            String cullingInfo;
            BoxCuller boxCuller;
            String distanceInfo;
            double distance2 = this.halfPlaneLength * renderMultiplier;
            String setter = "(set by shader pack)";
            if (renderMultiplier < 0.0f) {
                distance2 = IrisVideoSettings.shadowDistance * 16;
                setter = "(set by user)";
            }
            if (distance2 >= (double)(Minecraft.m_91087_().f_91066_.f_92106_ * 16)) {
                distanceInfo = "render distance = " + Minecraft.m_91087_().f_91066_.m_193772_() * 16 + " blocks ";
                distanceInfo = (String)distanceInfo + (Minecraft.m_91087_().m_91090_() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                boxCuller = null;
            } else {
                distanceInfo = distance2 + " blocks " + setter;
                if (distance2 == 0.0) {
                    cullingInfo = "no shadows rendered";
                    holder.setInfo(new CullEverythingFrustum(), distanceInfo, cullingInfo);
                }
                boxCuller = new BoxCuller(distance2);
            }
            cullingInfo = "Advanced Frustum Culling enabled";
            Vector4f shadowLightPosition = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
            Vector3f shadowLightVectorFromOrigin = new Vector3f(shadowLightPosition.x(), shadowLightPosition.y(), shadowLightPosition.z());
            shadowLightVectorFromOrigin.m_122278_();
            return holder.setInfo(new AdvancedShadowCullingFrustum(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), shadowLightVectorFromOrigin, boxCuller), distanceInfo, cullingInfo);
        }
        String distanceInfo = distance + " blocks (set by shader pack)";
        String cullingInfo = "distance only " + reason;
        BoxCuller boxCuller = new BoxCuller(distance);
        holder.setInfo(new BoxCullingFrustum(boxCuller), distanceInfo, cullingInfo);
        return holder;
    }

    public void setupShadowViewport() {
        RenderSystem.m_69949_((int)0, (int)0, (int)this.resolution, (int)this.resolution);
    }

    public void renderShadows(LevelRendererAccessor levelRenderer, Camera playerCamera) {
        Minecraft client = Minecraft.m_91087_();
        levelRenderer.getLevel().m_46473_().m_6182_("shadows");
        ACTIVE = true;
        visibleBlockEntities = new ArrayList<BlockEntity>();
        RenderBuffers playerBuffers = levelRenderer.getRenderBuffers();
        levelRenderer.setRenderBuffers(this.buffers);
        visibleBlockEntities = new ArrayList<BlockEntity>();
        PoseStack modelView = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize);
        MODELVIEW = modelView.m_85850_().m_85861_().m_27658_();
        levelRenderer.getLevel().m_46473_().m_6180_("terrain_setup");
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).saveState();
        }
        levelRenderer.getLevel().m_46473_().m_6180_("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x();
        double cameraY = cameraPos.y();
        double cameraZ = cameraPos.z();
        this.terrainFrustumHolder.getFrustum().m_113002_(cameraX, cameraY, cameraZ);
        levelRenderer.getLevel().m_46473_().m_7238_();
        boolean wasChunkCullingEnabled = client.f_90980_;
        client.f_90980_ = false;
        boolean regenerateClouds = levelRenderer.shouldRegenerateClouds();
        ((LevelRenderer)levelRenderer).m_109826_();
        levelRenderer.setShouldRegenerateClouds(regenerateClouds);
        levelRenderer.invokeSetupRender(playerCamera, this.terrainFrustumHolder.getFrustum(), false, false);
        client.f_90980_ = wasChunkCullingEnabled;
        levelRenderer.getLevel().m_46473_().m_6182_("terrain");
        this.setupShadowViewport();
        float[] projMatrix = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        Matrix4f shadowProjection = new Matrix4f();
        ((Matrix4fAccess)shadowProjection).copyFromArray(projMatrix);
        IrisRenderSystem.setShadowProjection(shadowProjection);
        RenderSystem.m_69464_();
        if (this.shouldRenderTerrain) {
            levelRenderer.invokeRenderChunkLayer(RenderType.m_110451_(), modelView, cameraX, cameraY, cameraZ, shadowProjection);
            levelRenderer.invokeRenderChunkLayer(RenderType.m_110463_(), modelView, cameraX, cameraY, cameraZ, shadowProjection);
            levelRenderer.invokeRenderChunkLayer(RenderType.m_110457_(), modelView, cameraX, cameraY, cameraZ, shadowProjection);
        }
        RenderSystem.m_69949_((int)0, (int)0, (int)this.resolution, (int)this.resolution);
        levelRenderer.getLevel().m_46473_().m_6182_("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean hasEntityFrustum = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            hasEntityFrustum = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        Frustum entityShadowFrustum = this.entityFrustumHolder.getFrustum();
        entityShadowFrustum.m_113002_(cameraX, cameraY, cameraZ);
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.beginLevelRendering();
        }
        if (this.buffers instanceof DrawCallTrackingRenderBuffers) {
            ((DrawCallTrackingRenderBuffers)this.buffers).resetDrawCounts();
        }
        MultiBufferSource.BufferSource bufferSource = this.buffers.m_110104_();
        EntityRenderDispatcher dispatcher = levelRenderer.getEntityRenderDispatcher();
        if (this.shouldRenderEntities) {
            this.renderedShadowEntities = this.renderEntities(levelRenderer, dispatcher, bufferSource, modelView, tickDelta, entityShadowFrustum, cameraX, cameraY, cameraZ);
        } else if (this.shouldRenderPlayer) {
            this.renderedShadowEntities = this.renderPlayerEntity(levelRenderer, dispatcher, bufferSource, modelView, tickDelta, entityShadowFrustum, cameraX, cameraY, cameraZ);
        }
        levelRenderer.getLevel().m_46473_().m_6182_("build blockentities");
        if (this.shouldRenderBlockEntities) {
            this.renderedShadowBlockEntities = this.renderBlockEntities(bufferSource, modelView, cameraX, cameraY, cameraZ, tickDelta, hasEntityFrustum);
        }
        levelRenderer.getLevel().m_46473_().m_6182_("draw entities");
        bufferSource.m_109911_();
        this.copyPreTranslucentDepth(levelRenderer);
        levelRenderer.getLevel().m_46473_().m_6182_("translucent terrain");
        if (this.shouldRenderTranslucent) {
            levelRenderer.invokeRenderChunkLayer(RenderType.m_110466_(), modelView, cameraX, cameraY, cameraZ, shadowProjection);
        }
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.endLevelRendering();
        }
        IrisRenderSystem.restorePlayerProjection();
        this.debugStringTerrain = ((LevelRenderer)levelRenderer).m_109820_();
        levelRenderer.getLevel().m_46473_().m_6182_("generate mipmaps");
        this.generateMipmaps();
        levelRenderer.getLevel().m_46473_().m_6182_("restore gl state");
        RenderSystem.m_69481_();
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        RenderSystem.m_69949_((int)0, (int)0, (int)client.m_91385_().f_83915_, (int)client.m_91385_().f_83916_);
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).restoreState();
        }
        levelRenderer.setRenderBuffers(playerBuffers);
        visibleBlockEntities = null;
        ACTIVE = false;
        levelRenderer.getLevel().m_46473_().m_7238_();
        levelRenderer.getLevel().m_46473_().m_6182_("updatechunks");
    }

    private int renderBlockEntities(MultiBufferSource.BufferSource bufferSource, PoseStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta, boolean hasEntityFrustum) {
        ShadowRenderer.getLevel().m_46473_().m_6180_("build blockentities");
        int shadowBlockEntities = 0;
        BoxCuller culler = null;
        if (hasEntityFrustum) {
            culler = new BoxCuller(this.halfPlaneLength * (this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier));
            culler.setPosition(cameraX, cameraY, cameraZ);
        }
        for (BlockEntity entity : visibleBlockEntities) {
            BlockPos pos = entity.m_58899_();
            if (hasEntityFrustum && culler.isCulled(pos.m_123341_() - 1, pos.m_123342_() - 1, pos.m_123343_() - 1, pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1)) continue;
            modelView.m_85836_();
            modelView.m_85837_((double)pos.m_123341_() - cameraX, (double)pos.m_123342_() - cameraY, (double)pos.m_123343_() - cameraZ);
            Minecraft.m_91087_().m_167982_().m_112267_(entity, tickDelta, modelView, (MultiBufferSource)bufferSource);
            modelView.m_85849_();
            ++shadowBlockEntities;
        }
        ShadowRenderer.getLevel().m_46473_().m_7238_();
        return shadowBlockEntities;
    }

    private int renderEntities(LevelRendererAccessor levelRenderer, EntityRenderDispatcher dispatcher, MultiBufferSource.BufferSource bufferSource, PoseStack modelView, float tickDelta, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        levelRenderer.getLevel().m_46473_().m_6180_("cull");
        ArrayList<Entity> renderedEntities = new ArrayList<Entity>(32);
        for (Entity entity2 : ShadowRenderer.getLevel().m_104735_()) {
            if (!dispatcher.m_114397_(entity2, frustum, cameraX, cameraY, cameraZ) || entity2.m_5833_()) continue;
            renderedEntities.add(entity2);
        }
        levelRenderer.getLevel().m_46473_().m_6182_("sort");
        renderedEntities.sort(Comparator.comparingInt(entity -> entity.m_6095_().hashCode()));
        levelRenderer.getLevel().m_46473_().m_6182_("build entity geometry");
        for (Entity entity2 : renderedEntities) {
            levelRenderer.invokeRenderEntity(entity2, cameraX, cameraY, cameraZ, tickDelta, modelView, (MultiBufferSource)bufferSource);
        }
        levelRenderer.getLevel().m_46473_().m_7238_();
        return renderedEntities.size();
    }

    private int renderPlayerEntity(LevelRendererAccessor levelRenderer, EntityRenderDispatcher dispatcher, MultiBufferSource.BufferSource bufferSource, PoseStack modelView, float tickDelta, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        levelRenderer.getLevel().m_46473_().m_6180_("cull");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int shadowEntities = 0;
        if (!dispatcher.m_114397_((Entity)player, frustum, cameraX, cameraY, cameraZ) || player.m_5833_()) {
            return 0;
        }
        levelRenderer.getLevel().m_46473_().m_6182_("build geometry");
        if (!player.m_20197_().isEmpty()) {
            for (int i = 0; i < player.m_20197_().size(); ++i) {
                levelRenderer.invokeRenderEntity((Entity)player.m_20197_().get(i), cameraX, cameraY, cameraZ, tickDelta, modelView, (MultiBufferSource)bufferSource);
                ++shadowEntities;
            }
        }
        if (player.m_20202_() != null) {
            levelRenderer.invokeRenderEntity(player.m_20202_(), cameraX, cameraY, cameraZ, tickDelta, modelView, (MultiBufferSource)bufferSource);
            ++shadowEntities;
        }
        levelRenderer.invokeRenderEntity((Entity)player, cameraX, cameraY, cameraZ, tickDelta, modelView, (MultiBufferSource)bufferSource);
        levelRenderer.getLevel().m_46473_().m_7238_();
        return ++shadowEntities;
    }

    private void copyPreTranslucentDepth(LevelRendererAccessor levelRenderer) {
        levelRenderer.getLevel().m_46473_().m_6182_("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    public void addDebugText(List<String> messages) {
        messages.add("[Oculus] Shadow Maps: " + this.debugStringOverall);
        messages.add("[Oculus] Shadow Distance Terrain: " + this.terrainFrustumHolder.getDistanceInfo() + " Entity: " + this.entityFrustumHolder.getDistanceInfo());
        messages.add("[Oculus] Shadow Culling Terrain: " + this.terrainFrustumHolder.getCullingInfo() + " Entity: " + this.entityFrustumHolder.getCullingInfo());
        messages.add("[Oculus] Shadow Terrain: " + this.debugStringTerrain + (this.shouldRenderTerrain ? "" : " (no terrain) ") + (this.shouldRenderTranslucent ? "" : "(no translucent)"));
        messages.add("[Oculus] Shadow Entities: " + this.getEntitiesDebugString());
        messages.add("[Oculus] Shadow Block Entities: " + this.getBlockEntitiesDebugString());
        if (this.buffers instanceof DrawCallTrackingRenderBuffers && (this.shouldRenderEntities || this.shouldRenderPlayer)) {
            DrawCallTrackingRenderBuffers drawCallTracker = (DrawCallTrackingRenderBuffers)this.buffers;
            messages.add("[Oculus] Shadow Entity Batching: " + BatchingDebugMessageHelper.getDebugMessage(drawCallTracker));
        }
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? this.renderedShadowEntities + "/" + Minecraft.m_91087_().f_91073_.m_104813_() : "disabled by pack";
    }

    private String getBlockEntitiesDebugString() {
        return this.shouldRenderBlockEntities ? "" + this.renderedShadowBlockEntities : "disabled by pack";
    }

    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int texture, int targetFilteringMode) {
            this.texture = texture;
            this.targetFilteringMode = targetFilteringMode;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

