/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.pipeline.newshader.IrisProgramTypes;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.ShaderInstanceInterface;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public class ExtendedShader
extends ShaderInstance
implements SamplerHolder,
ImageHolder,
ShaderInstanceInterface {
    private final boolean intensitySwizzle;
    private final ProgramImages.Builder imageBuilder;
    NewWorldRenderingPipeline parent;
    ProgramUniforms f_173331_;
    GlFramebuffer writingToBeforeTranslucent;
    GlFramebuffer writingToAfterTranslucent;
    GlFramebuffer baseline;
    BlendModeOverride blendModeOverride;
    HashMap<String, IntSupplier> dynamicSamplers;
    float alphaTest;
    private ProgramImages currentImages;
    private Program geometry;
    private boolean isFullbright;
    private final ShaderAttributeInputs inputs;

    public ExtendedShader(ResourceProvider resourceFactory, String string, VertexFormat vertexFormat, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, GlFramebuffer baseline, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicUniformHolder> uniformCreator, boolean isFullbright, NewWorldRenderingPipeline parent, ShaderAttributeInputs inputs) throws IOException {
        super(resourceFactory, string, vertexFormat);
        int programId = this.m_142658_();
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        uniformCreator.accept(uniformBuilder);
        this.f_173331_ = uniformBuilder.buildUniforms();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.baseline = baseline;
        this.blendModeOverride = blendModeOverride;
        this.dynamicSamplers = new HashMap();
        this.alphaTest = alphaTest.getReference();
        this.parent = parent;
        this.imageBuilder = ProgramImages.builder(programId);
        this.currentImages = null;
        this.isFullbright = isFullbright;
        this.inputs = inputs;
        this.intensitySwizzle = this.m_173365_().contains("intensity");
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void m_173362_() {
        ProgramUniforms.clearActiveUniforms();
        super.m_173362_();
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
        Minecraft.m_91087_().m_91385_().m_83947_(false);
    }

    public void m_173363_() {
        this.dynamicSamplers.forEach((name, supplier) -> this.addIrisSampler((String)name, supplier.getAsInt()));
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        if (!this.inputs.hasTex()) {
            this.m_173350_("Sampler0", this.parent.getWhitePixel().m_117963_());
        }
        if (!this.inputs.hasLight()) {
            this.m_173350_("Sampler2", this.parent.getWhitePixel().m_117963_());
        }
        super.m_173363_();
        this.f_173331_.update();
        if (this.currentImages == null) {
            this.currentImages = this.imageBuilder.build();
        }
        this.currentImages.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    public void addIrisSampler(String name, int id) {
        super.m_173350_(name, (Object)id);
    }

    public void addIrisSampler(String name, IntSupplier supplier) {
        this.dynamicSamplers.put(name, supplier);
    }

    public void m_173350_(String name, Object sampler) {
        if (name.equals("Sampler0")) {
            name = "gtexture";
            super.m_173350_("texture", sampler);
            super.m_173350_("tex", sampler);
        } else if (name.equals("Sampler1")) {
            name = "iris_overlay";
        } else if (name.equals("Sampler2")) {
            name = "lightmap";
        } else {
            if (name.startsWith("Sampler")) {
                return;
            }
            Iris.logger.warn("Iris: didn't recognize the sampler name " + name + " in addSampler, please use addIrisSampler for custom Iris-specific samplers instead.");
            return;
        }
        super.m_173350_(name, sampler);
    }

    @Nullable
    public Uniform m_173348_(String name) {
        return super.m_173348_("iris_" + name);
    }

    @Override
    public void addExternalSampler(int textureUnit, String ... names) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean hasSampler(String name) {
        return GlStateManager.m_84345_((int)this.m_142658_(), (CharSequence)name) != -1;
    }

    @Override
    public boolean addDefaultSampler(IntSupplier sampler, String ... names) {
        throw new UnsupportedOperationException("addDefaultSampler is not yet implemented");
    }

    @Override
    public boolean addDynamicSampler(IntSupplier sampler, String ... names) {
        boolean used = false;
        for (String name : names) {
            if (this.hasSampler(name)) {
                used = true;
            }
            this.addIrisSampler(name, sampler);
        }
        return used;
    }

    @Override
    public boolean hasImage(String name) {
        return this.imageBuilder.hasImage(name);
    }

    @Override
    public void addTextureImage(IntSupplier textureID, InternalTextureFormat internalFormat, String name) {
        this.imageBuilder.addTextureImage(textureID, internalFormat, name);
        this.currentImages = null;
    }

    public void m_142662_() {
        super.m_142662_();
        if (this.geometry != null) {
            this.geometry.m_166610_((Shader)this);
        }
    }

    @Override
    public void iris$createGeometryShader(ResourceProvider factory, ResourceLocation name) throws IOException {
        Resource geometry = factory.m_142591_(new ResourceLocation("minecraft", name.m_135815_() + "_geometry.gsh"));
        if (geometry != null) {
            this.geometry = Program.m_166604_((Program.Type)IrisProgramTypes.GEOMETRY, (String)name.m_135815_(), (InputStream)geometry.m_6679_(), (String)geometry.m_7816_(), (GlslPreprocessor)new GlslPreprocessor(){

                @Nullable
                public String m_142138_(boolean bl, String string) {
                    return null;
                }
            });
        }
    }

    public Program getGeometry() {
        return this.geometry;
    }
}

