/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ShaderProperties;

public class PackShadowDirectives {
    public static final int MAX_SHADOW_COLOR_BUFFERS = 2;
    private int resolution;
    private Float fov;
    private float distance;
    private float distanceRenderMul;
    private float entityShadowDistanceMul;
    private boolean explicitRenderDistance;
    private float intervalSize;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final OptionalBoolean cullingState;
    private final ImmutableList<DepthSamplingSettings> depthSamplingSettings;
    private final ImmutableList<SamplingSettings> colorSamplingSettings;

    public PackShadowDirectives(ShaderProperties properties) {
        this.resolution = 1024;
        this.fov = null;
        this.distance = 160.0f;
        this.distanceRenderMul = -1.0f;
        this.entityShadowDistanceMul = 1.0f;
        this.explicitRenderDistance = false;
        this.intervalSize = 2.0f;
        this.shouldRenderTerrain = properties.getShadowTerrain().orElse(true);
        this.shouldRenderTranslucent = properties.getShadowTranslucent().orElse(true);
        this.shouldRenderEntities = properties.getShadowEntities().orElse(true);
        this.shouldRenderPlayer = properties.getShadowPlayer().orElse(false);
        this.shouldRenderBlockEntities = properties.getShadowBlockEntities().orElse(true);
        this.cullingState = properties.getShadowCulling();
        this.depthSamplingSettings = ImmutableList.of((Object)new DepthSamplingSettings(), (Object)new DepthSamplingSettings());
        ImmutableList.Builder colorSamplingSettings = ImmutableList.builder();
        for (int i = 0; i < 2; ++i) {
            colorSamplingSettings.add((Object)new SamplingSettings());
        }
        this.colorSamplingSettings = colorSamplingSettings.build();
    }

    public PackShadowDirectives(PackShadowDirectives shadowDirectives) {
        this.resolution = shadowDirectives.resolution;
        this.fov = shadowDirectives.fov;
        this.distance = shadowDirectives.distance;
        this.distanceRenderMul = shadowDirectives.distanceRenderMul;
        this.entityShadowDistanceMul = shadowDirectives.entityShadowDistanceMul;
        this.explicitRenderDistance = shadowDirectives.explicitRenderDistance;
        this.intervalSize = shadowDirectives.intervalSize;
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain;
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent;
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities;
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer;
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities;
        this.cullingState = shadowDirectives.cullingState;
        this.depthSamplingSettings = shadowDirectives.depthSamplingSettings;
        this.colorSamplingSettings = shadowDirectives.colorSamplingSettings;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Float getFov() {
        return this.fov;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getDistanceRenderMul() {
        return this.distanceRenderMul;
    }

    public float getEntityShadowDistanceMul() {
        return this.entityShadowDistanceMul;
    }

    public boolean isDistanceRenderMulExplicit() {
        return this.explicitRenderDistance;
    }

    public float getIntervalSize() {
        return this.intervalSize;
    }

    public boolean shouldRenderTerrain() {
        return this.shouldRenderTerrain;
    }

    public boolean shouldRenderTranslucent() {
        return this.shouldRenderTranslucent;
    }

    public boolean shouldRenderEntities() {
        return this.shouldRenderEntities;
    }

    public boolean shouldRenderPlayer() {
        return this.shouldRenderPlayer;
    }

    public boolean shouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public OptionalBoolean getCullingState() {
        return this.cullingState;
    }

    public ImmutableList<DepthSamplingSettings> getDepthSamplingSettings() {
        return this.depthSamplingSettings;
    }

    public ImmutableList<SamplingSettings> getColorSamplingSettings() {
        return this.colorSamplingSettings;
    }

    public void acceptDirectives(DirectiveHolder directives) {
        directives.acceptCommentIntDirective("SHADOWRES", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptConstIntDirective("shadowMapResolution", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptCommentFloatDirective("SHADOWFOV", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptConstFloatDirective("shadowMapFov", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptCommentFloatDirective("SHADOWHPL", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("shadowDistance", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("entityShadowDistanceMul", distance -> {
            this.entityShadowDistanceMul = distance;
        });
        directives.acceptConstFloatDirective("shadowDistanceRenderMul", distanceRenderMul -> {
            this.distanceRenderMul = distanceRenderMul;
            this.explicitRenderDistance = true;
        });
        directives.acceptConstFloatDirective("shadowIntervalSize", intervalSize -> {
            this.intervalSize = intervalSize;
        });
        PackShadowDirectives.acceptHardwareFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptDepthMipmapSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorMipmapSettings(directives, this.colorSamplingSettings);
        PackShadowDirectives.acceptDepthFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorFilteringSettings(directives, this.colorSamplingSettings);
    }

    private static void acceptHardwareFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("shadowHardwareFiltering", hardwareFiltering -> {
            for (DepthSamplingSettings samplerSettings : samplers) {
                samplerSettings.setHardwareFiltering(hardwareFiltering);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowHardwareFiltering" + i;
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setHardwareFiltering);
        }
    }

    private static void acceptDepthMipmapSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexMipmap", ((DepthSamplingSettings)samplers.get(0))::setMipmap);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowtex" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptColorMipmapSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowColorMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowcolor" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
            name = "shadowColor" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptDepthFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexNearest", ((DepthSamplingSettings)samplers.get(0))::setNearest);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowtex" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
            name = "shadow" + i + "MinMagNearest";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
        }
    }

    private static void acceptColorFilteringSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowcolor" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = "shadowColor" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = "shadowColor" + i + "MinMagNearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
        }
    }

    public String toString() {
        return "PackShadowDirectives{resolution=" + this.resolution + ", fov=" + this.fov + ", distance=" + this.distance + ", distanceRenderMul=" + this.distanceRenderMul + ", entityDistanceRenderMul=" + this.entityShadowDistanceMul + ", intervalSize=" + this.intervalSize + ", depthSamplingSettings=" + this.depthSamplingSettings + ", colorSamplingSettings=" + this.colorSamplingSettings + "}";
    }

    public static class DepthSamplingSettings
    extends SamplingSettings {
        private boolean hardwareFiltering = false;

        private void setHardwareFiltering(boolean hardwareFiltering) {
            this.hardwareFiltering = hardwareFiltering;
        }

        public boolean getHardwareFiltering() {
            return this.hardwareFiltering;
        }

        @Override
        public String toString() {
            return "DepthSamplingSettings{mipmap=" + this.getMipmap() + ", nearest=" + this.getNearest() + ", hardwareFiltering=" + this.hardwareFiltering + "}";
        }
    }

    public static class SamplingSettings {
        private boolean mipmap = false;
        private boolean nearest = false;

        protected void setMipmap(boolean mipmap) {
            this.mipmap = mipmap;
        }

        protected void setNearest(boolean nearest) {
            this.nearest = nearest;
        }

        public boolean getMipmap() {
            return this.mipmap;
        }

        public boolean getNearest() {
            return this.nearest;
        }

        public String toString() {
            return "SamplingSettings{mipmap=" + this.mipmap + ", nearest=" + this.nearest + "}";
        }
    }
}

