/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tfc_decoration.block;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mrthomas20121.tfc_decoration.item.TFCDecItems;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TFCDecBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tfc_decoration");
    public static final Map<Rock, RegistryObject<RotatedPillarBlock>> PILLARS = Helpers.mapOfKeys(Rock.class, rock -> TFCDecBlocks.register("pillar/" + rock.name(), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f))));
    public static final Map<Rock, RegistryObject<Block>> ROCKWOOL = Helpers.mapOfKeys(Rock.class, rock -> TFCDecBlocks.register("rockwool/" + rock.name(), () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.4f))));
    public static RegistryObject<Block> POLISHED_FIRE_CLAY = TFCDecBlocks.register("polished_fire_clay", 0.3f);

    private static RegistryObject<Block> register(String name, float strength) {
        return TFCDecBlocks.register(name, () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(strength)), (T block) -> new BlockItem(block, new Item.Properties().m_41491_(TFCItemGroup.DECORATIONS)));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return TFCDecBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties().m_41491_(TFCItemGroup.DECORATIONS)));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return TFCDecBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        String actualName = name.toLowerCase(Locale.ROOT);
        RegistryObject block = BLOCKS.register(actualName, blockSupplier);
        if (blockItemFactory != null) {
            TFCDecItems.ITEMS.register(actualName, () -> (BlockItem)blockItemFactory.apply((Block)block.get()));
        }
        return block;
    }
}

