/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

@WailaPlugin(id="waystones")
public class WailaProvider
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)new WaystoneDataProvider(), TooltipPosition.BODY, WaystoneBlockBase.class);
    }

    private static class WaystoneDataProvider
    implements IComponentProvider {
        private WaystoneDataProvider() {
        }

        public void appendBody(List<Component> tooltip, IDataAccessor accessor, IPluginConfig config) {
            BlockEntity tileEntity = accessor.getBlockEntity();
            if (!(tileEntity instanceof WarpPlateBlockEntity) && tileEntity instanceof WaystoneBlockEntityBase) {
                boolean isActivated;
                IWaystone waystone = ((WaystoneBlockEntityBase)tileEntity).getWaystone();
                boolean bl = isActivated = !waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(accessor.getPlayer(), waystone);
                if (isActivated && waystone.hasName() && waystone.isValid()) {
                    tooltip.add((Component)new TextComponent(waystone.getName()));
                } else {
                    tooltip.add((Component)new TranslatableComponent("tooltip.waystones.undiscovered"));
                }
            }
        }
    }
}

