/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.Collections;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllTags {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Create.registrate().creativeModeTab(() -> Create.BASE_CREATIVE_TAB);

    public static <T extends IForgeRegistryEntry<T>> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T extends IForgeRegistryEntry<T>> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return AllTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_}).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(new TagKey[]{AllTags.forgeBlockTag(p)});
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(new TagKey[]{AllTags.forgeItemTag(p)});
            }
            return item;
        };
    }

    public static void register() {
        AllFluidTags.BOTTOMLESS_ALLOW.add(new Fluid[]{Fluids.f_76193_, Fluids.f_76195_});
        AllItemTags.VANILLA_STRIPPED_LOGS.add(Items.f_41849_, Items.f_41847_, Items.f_41851_, Items.f_41850_, Items.f_41848_, Items.f_41845_, Items.f_41846_, Items.f_41879_);
        AllItemTags.VANILLA_STRIPPED_LOGS.includeIn(AllItemTags.STRIPPED_LOGS);
        AllItemTags.VANILLA_STRIPPED_WOOD.add(Items.f_41884_, Items.f_41882_, Items.f_41886_, Items.f_41885_, Items.f_41883_, Items.f_41880_, Items.f_41881_, Items.f_41887_);
        AllItemTags.VANILLA_STRIPPED_WOOD.includeIn(AllItemTags.STRIPPED_WOOD);
        AllItemTags.CREATE_INGOTS.includeIn(AllItemTags.BEACON_PAYMENT);
        AllItemTags.CREATE_INGOTS.includeIn((TagKey<Item>)Tags.Items.INGOTS);
        AllItemTags.UPRIGHT_ON_BELT.add(Items.f_42590_, Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42787_, Items.f_42502_);
        AllItemTags.SLEEPERS.add(Items.f_41922_, Items.f_41923_, Items.f_42336_);
        AllBlockTags.WINDMILL_SAILS.includeAll((TagKey<Block>)BlockTags.f_13089_);
        AllBlockTags.BRITTLE.includeAll((TagKey<Block>)BlockTags.f_13103_);
        AllBlockTags.BRITTLE.includeAll((TagKey<Block>)BlockTags.f_13038_);
        AllBlockTags.BRITTLE.add(Blocks.f_50276_, Blocks.f_50680_, Blocks.f_50262_);
        AllBlockTags.FAN_TRANSPARENT.includeAll((TagKey<Block>)BlockTags.f_13039_);
        AllBlockTags.FAN_TRANSPARENT.includeAll((TagKey<Block>)BlockTags.f_13087_);
        AllBlockTags.FAN_TRANSPARENT.add(Blocks.f_50183_);
        AllBlockTags.PASSIVE_BOILER_HEATERS.includeAll((TagKey<Block>)BlockTags.f_13076_);
        AllBlockTags.PASSIVE_BOILER_HEATERS.includeAll((TagKey<Block>)BlockTags.f_13087_);
        AllBlockTags.PASSIVE_BOILER_HEATERS.add(Blocks.f_50450_, Blocks.f_49991_);
        AllBlockTags.SAFE_NBT.includeAll((TagKey<Block>)BlockTags.f_13068_);
        AllBlockTags.SAFE_NBT.includeAll((TagKey<Block>)BlockTags.f_13028_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13034_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13093_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13099_);
        AllBlockTags.WRENCH_PICKUP.add(Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50146_, Blocks.f_50164_, Blocks.f_50328_, Blocks.f_50455_, Blocks.f_50123_, Blocks.f_50039_, Blocks.f_50032_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50329_, Blocks.f_50716_);
        AllBlockTags.ORE_OVERRIDE_STONE.includeAll((TagKey<Block>)BlockTags.f_144266_);
        AllTags.registerCompat();
    }

    private static void registerCompat() {
        AllBlockTags.NON_MOVABLE.addOptional(Mods.IE, "connector_lv", "connector_lv_relay", "connector_mv", "connector_mv_relay", "connector_hv", "connector_hv_relay", "connector_bundled", "connector_structural", "connector_redstone", "connector_probe", "breaker_switch");
        AllTags.strippedWoodCompat(Mods.ARS_N, "blue_archwood", "purple_archwood", "green_archwood", "red_archwood");
        AllTags.strippedWoodCompat(Mods.BTN, "livingwood", "dreamwood");
        AllTags.strippedWoodCompat(Mods.FA, "cherrywood", "mysterywood");
        AllTags.strippedWoodCompat(Mods.HEX, "akashic");
        AllTags.strippedWoodCompat(Mods.ID, "menril");
        AllTags.strippedWoodCompat(Mods.BYG, "aspen", "baobab", "enchanted", "cherry", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "mangrove", "maple", "nightshade", "palm", "palo_verde", "pine", "rainbow_eucalyptus", "redwood", "skyris", "willow", "witch_hazel", "zelkova");
        AllTags.strippedWoodCompat(Mods.SG, "netherwood");
        AllTags.strippedWoodCompat(Mods.TF, "twilight_oak", "canopy", "mangrove", "dark", "time", "transformation", "mining", "sorting");
        AllTags.strippedWoodCompat(Mods.TIC, "greenheart", "skyroot", "bloodshroom");
        AllTags.strippedWoodCompat(Mods.AP, "twisted");
        AllTags.strippedWoodCompat(Mods.Q, "azalea", "blossom");
        AllTags.strippedWoodCompat(Mods.ECO, "coconut", "walnut", "azalea");
        AllTags.strippedWoodCompat(Mods.BOP, "fir", "redwood", "cherry", "mahogany", "jacaranda", "palm", "willow", "dead", "magic", "umbran", "hellbark");
        AllTags.strippedWoodCompat(Mods.BSK, "bluebright", "starlit", "frostbright", "lunar", "dusk", "maple", "cherry");
        AllItemTags.MODDED_STRIPPED_LOGS.addOptional(Mods.BYG, "stripped_bulbis_stem");
        AllItemTags.MODDED_STRIPPED_WOOD.addOptional(Mods.BYG, "stripped_bulbis_wood");
        AllItemTags.MODDED_STRIPPED_LOGS.includeIn(AllItemTags.STRIPPED_LOGS);
        AllItemTags.MODDED_STRIPPED_WOOD.includeIn(AllItemTags.STRIPPED_WOOD);
    }

    private static void strippedWoodCompat(Mods mod, String ... woodtypes) {
        for (int i = 0; i < woodtypes.length; ++i) {
            String type = woodtypes[i];
            String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
            String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
            AllItemTags.MODDED_STRIPPED_LOGS.addOptional(mod, strippedPre + type + "_log" + strippedPost);
            AllItemTags.MODDED_STRIPPED_WOOD.addOptional(mod, strippedPre + type + (mod.omitWoodSuffix ? "" : "_wood") + strippedPost);
        }
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        HONEY(NameSpace.FORGE);

        public final TagKey<Fluid> tag;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        public void add(Fluid ... values) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(TagKey<Fluid> parent) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllFluidTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Fluid> child) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CASING,
        CREATE_INGOTS,
        CRUSHED_ORES,
        PRESSURIZED_AIR_SOURCES,
        SANDPAPER,
        SEATS,
        SLEEPERS,
        TOOLBOXES,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        VANILLA_STRIPPED_LOGS,
        VANILLA_STRIPPED_WOOD,
        MODDED_STRIPPED_LOGS,
        MODDED_STRIPPED_WOOD,
        STRIPPED_LOGS(NameSpace.FORGE),
        STRIPPED_WOOD(NameSpace.FORGE),
        BEACON_PAYMENT(NameSpace.FORGE),
        PLATES(NameSpace.FORGE),
        WRENCH(NameSpace.FORGE, "tools/wrench");

        public final TagKey<Item> tag;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        public void add(Item ... values) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void addOptional(Mods mod, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(mod.asResource(id));
                }
            });
        }

        public void includeIn(TagKey<Item> parent) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllItemTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Item> child) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum AllBlockTags {
        BRITTLE,
        CASING,
        FAN_TRANSPARENT,
        NON_MOVABLE,
        ORE_OVERRIDE_STONE,
        PASSIVE_BOILER_HEATERS,
        SAFE_NBT,
        SEATS,
        TOOLBOXES,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WINDOWABLE,
        WRENCH_PICKUP,
        RELOCATION_NOT_SUPPORTED(NameSpace.FORGE),
        WG_STONE(NameSpace.FORGE),
        SLIMY_LOGS(NameSpace.TIC),
        NON_DOUBLE_DOOR(NameSpace.QUARK);

        public final TagKey<Block> tag;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public void add(Block ... values) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void addOptional(Mods mod, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(mod.asResource(id));
                }
            });
        }

        public void includeIn(TagKey<Block> parent) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllBlockTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Block> child) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

