/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DirectionalAxisKineticBlock
extends DirectionalKineticBlock
implements ITransformableBlock {
    public static final BooleanProperty AXIS_ALONG_FIRST_COORDINATE = BooleanProperty.m_61465_((String)"axis_along_first");

    public DirectionalAxisKineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS_ALONG_FIRST_COORDINATE});
        super.m_7926_(builder);
    }

    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        Direction facing = context.m_7820_().m_122424_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            facing = facing.m_122424_();
        }
        return facing;
    }

    protected boolean getAxisAlignmentForPlacement(BlockPlaceContext context) {
        return context.m_8125_().m_122434_() == Direction.Axis.X;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = this.getFacingForPlacement(context);
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        boolean alongFirst = false;
        Direction.Axis faceAxis = facing.m_122434_();
        if (faceAxis.m_122479_()) {
            alongFirst = faceAxis == Direction.Axis.Z;
            Direction positivePerpendicular = faceAxis == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
            boolean shaftAbove = this.prefersConnectionTo((LevelReader)world, pos, Direction.UP, true);
            boolean shaftBelow = this.prefersConnectionTo((LevelReader)world, pos, Direction.DOWN, true);
            boolean preferLeft = this.prefersConnectionTo((LevelReader)world, pos, positivePerpendicular, false);
            boolean preferRight = this.prefersConnectionTo((LevelReader)world, pos, positivePerpendicular.m_122424_(), false);
            if (shaftAbove || shaftBelow || preferLeft || preferRight) {
                boolean bl = alongFirst = faceAxis == Direction.Axis.X;
            }
        }
        if (faceAxis.m_122478_()) {
            alongFirst = this.getAxisAlignmentForPlacement(context);
            Direction prefferedSide = null;
            for (Direction side : Iterate.horizontalDirections) {
                if (!this.prefersConnectionTo((LevelReader)world, pos, side, true) && !this.prefersConnectionTo((LevelReader)world, pos, side.m_122427_(), false)) continue;
                if (prefferedSide != null && prefferedSide.m_122434_() != side.m_122434_()) {
                    prefferedSide = null;
                    break;
                }
                prefferedSide = side;
            }
            if (prefferedSide != null) {
                alongFirst = prefferedSide.m_122434_() == Direction.Axis.X;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    protected boolean prefersConnectionTo(LevelReader reader, BlockPos pos, Direction facing, boolean shaftAxis) {
        if (!shaftAxis) {
            return false;
        }
        BlockPos neighbourPos = pos.m_142300_(facing);
        BlockState blockState = reader.m_8055_(neighbourPos);
        Block block = blockState.m_60734_();
        return block instanceof IRotate && ((IRotate)block).hasShaftTowards(reader, neighbourPos, blockState, facing.m_122424_());
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        Direction.Axis pistonAxis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        boolean alongFirst = (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE);
        if (pistonAxis == Direction.Axis.X) {
            return alongFirst ? Direction.Axis.Y : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Y) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Z) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Y;
        }
        throw new IllegalStateException("Unknown axis??");
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            state = (BlockState)state.m_61122_((Property)AXIS_ALONG_FIRST_COORDINATE);
        }
        return super.m_6843_(state, rot);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.m_6843_(state, transform.rotation);
        }
        Direction newFacing = transform.rotateFacing((Direction)state.m_61143_((Property)FACING));
        if (transform.rotationAxis == newFacing.m_122434_() && transform.rotation.ordinal() % 2 == 1) {
            state = (BlockState)state.m_61122_((Property)AXIS_ALONG_FIRST_COORDINATE);
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == this.getRotationAxis(state);
    }
}

