/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.MinecartSim2020;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;

public class CouplingPhysics {
    public static void tick(Level world) {
        CouplingHandler.forEachLoadedCoupling(world, c -> CouplingPhysics.tickCoupling(world, c));
    }

    public static void tickCoupling(Level world, Couple<MinecartController> c) {
        Couple<AbstractMinecart> carts = c.map(MinecartController::cart);
        float couplingLength = ((MinecartController)c.getFirst()).getCouplingLength(true);
        CouplingPhysics.softCollisionStep(world, carts, couplingLength);
        if (world.f_46443_) {
            return;
        }
        CouplingPhysics.hardCollisionStep(world, carts, couplingLength);
    }

    public static void hardCollisionStep(Level world, Couple<AbstractMinecart> carts, double couplingLength) {
        if (!MinecartSim2020.canAddMotion(((Couple)carts).get(false)) && MinecartSim2020.canAddMotion(((Couple)carts).get(true))) {
            carts = ((Couple)carts).swap();
        }
        Couple<Object> corrections = Couple.create(null, null);
        Couple<Float> maxSpeed = ((Couple)carts).map(IForgeAbstractMinecart::getMaxCartSpeedOnRail);
        boolean firstLoop = true;
        for (boolean current : new boolean[]{true, false, true}) {
            float correctionMagnitude;
            AbstractMinecart cart = (AbstractMinecart)((Couple)carts).get(current);
            AbstractMinecart otherCart = (AbstractMinecart)((Couple)carts).get(!current);
            float stress = (float)(couplingLength - cart.m_20182_().m_82554_(otherCart.m_20182_()));
            if (Math.abs(stress) < 0.125f) continue;
            RailShape shape = null;
            BlockPos railPosition = cart.getCurrentRailPosition();
            BlockState railState = world.m_8055_(railPosition.m_7494_());
            if (railState.m_60734_() instanceof BaseRailBlock) {
                BaseRailBlock block = (BaseRailBlock)railState.m_60734_();
                shape = block.getRailDirection(railState, (BlockGetter)world, railPosition, cart);
            }
            Vec3 correction = Vec3.f_82478_;
            Vec3 pos = cart.m_20182_();
            Vec3 link = otherCart.m_20182_().m_82546_(pos);
            float f = correctionMagnitude = firstLoop ? -stress / 2.0f : -stress;
            if (!MinecartSim2020.canAddMotion(cart)) {
                correctionMagnitude /= 2.0f;
            }
            correction = shape != null ? CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, MinecartSim2020.getRailVec(shape)).m_82546_(pos) : link.m_82541_().m_82490_((double)correctionMagnitude);
            float maxResolveSpeed = 1.75f;
            correction = VecHelper.clamp(correction, Math.min(maxResolveSpeed, maxSpeed.get(current).floatValue()));
            if (corrections.get(current) == null) {
                corrections.set(current, correction);
            }
            if (shape != null) {
                MinecartSim2020.moveCartAlongTrack(cart, correction, railPosition, railState);
            } else {
                cart.m_6478_(MoverType.SELF, correction);
                cart.m_20256_(cart.m_20184_().m_82490_((double)0.95f));
            }
            firstLoop = false;
        }
    }

    public static void softCollisionStep(Level world, Couple<AbstractMinecart> carts, double couplingLength) {
        Couple<Float> maxSpeed = carts.map(IForgeAbstractMinecart::getMaxCartSpeedOnRail);
        Couple<Boolean> canAddmotion = carts.map(MinecartSim2020::canAddMotion);
        Couple<Vec3> motions = carts.map(Entity::m_20184_);
        motions.replaceWithParams(VecHelper::clamp, Couple.create(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        Couple<Vec3> nextPositions = carts.map(MinecartSim2020::predictNextPositionOf);
        Couple<RailShape> shapes = carts.mapWithContext((minecart, current) -> {
            BlockPos railPosition;
            BlockState railState;
            int z;
            int y;
            Vec3 vec = (Vec3)nextPositions.get((boolean)current);
            int x = Mth.m_14107_((double)vec.m_7096_());
            BlockPos pos = new BlockPos(x, (y = Mth.m_14107_((double)vec.m_7098_())) - 1, z = Mth.m_14107_((double)vec.m_7094_()));
            if (minecart.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13034_)) {
                pos = pos.m_7495_();
            }
            if (!((railState = world.m_8055_((railPosition = pos).m_7494_())).m_60734_() instanceof BaseRailBlock)) {
                return null;
            }
            BaseRailBlock block = (BaseRailBlock)railState.m_60734_();
            return block.getRailDirection(railState, (BlockGetter)world, railPosition, minecart);
        });
        float futureStress = (float)(couplingLength - ((Vec3)nextPositions.getFirst()).m_82554_((Vec3)nextPositions.getSecond()));
        if (Mth.m_14082_((double)futureStress, (double)0.0)) {
            return;
        }
        for (boolean current2 : Iterate.trueAndFalse) {
            Vec3 correction = Vec3.f_82478_;
            Vec3 pos = nextPositions.get(current2);
            Vec3 link = nextPositions.get(!current2).m_82546_(pos);
            float correctionMagnitude = -futureStress / 2.0f;
            if (canAddmotion.get(current2) != canAddmotion.get(!current2)) {
                float f = correctionMagnitude = canAddmotion.get(current2) == false ? 0.0f : correctionMagnitude * 2.0f;
            }
            if (!canAddmotion.get(current2).booleanValue()) continue;
            RailShape shape = shapes.get(current2);
            if (shape != null) {
                Vec3 railVec = MinecartSim2020.getRailVec(shape);
                correction = CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, railVec).m_82546_(pos);
            } else {
                correction = link.m_82541_().m_82490_((double)correctionMagnitude);
            }
            correction = VecHelper.clamp(correction, maxSpeed.get(current2).floatValue());
            motions.set(current2, motions.get(current2).m_82549_(correction));
        }
        motions.replaceWithParams(VecHelper::clamp, maxSpeed);
        carts.forEachWithParams(Entity::m_20256_, motions);
    }

    public static Vec3 followLinkOnRail(Vec3 link, Vec3 cart, float diffToReduce, Vec3 railAxis) {
        double radius;
        Vec3 center;
        double dotProduct = railAxis.m_82526_(link);
        if (Double.isNaN(dotProduct) || dotProduct == 0.0 || diffToReduce == 0.0f) {
            return cart;
        }
        Vec3 axis = railAxis.m_82490_(-Math.signum(dotProduct));
        Vec3 intersectSphere = VecHelper.intersectSphere(cart, axis, center = cart.m_82549_(link), radius = link.m_82553_() - (double)diffToReduce);
        if (intersectSphere == null) {
            return cart.m_82549_(VecHelper.project(link, axis));
        }
        return intersectSphere;
    }
}

