/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.PumpTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class PumpBlock
extends DirectionalKineticBlock
implements SimpleWaterloggedBlock,
ICogWheel,
ITE<PumpTileEntity> {
    public PumpBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61124_((Property)FACING, (Comparable)((Direction)originalState.m_61143_((Property)FACING)).m_122424_());
    }

    @Override
    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return super.updateAfterWrenched(newState, context);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.PUMP.get((Direction)state.m_61143_((Property)FACING));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!PumpBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState toPlace = super.m_5573_(context);
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        toPlace = ProperWaterloggedBlock.withWater((LevelAccessor)level, toPlace, pos);
        if (player != null && player.m_20161_()) {
            return toPlace;
        }
        for (Direction d : Iterate.directions) {
            BlockState adjState;
            BlockPos adjPos = pos.m_142300_(d);
            if (!FluidPipeBlock.canConnectTo((BlockAndTintGetter)level, adjPos, adjState = level.m_8055_(adjPos), d)) continue;
            toPlace = (BlockState)toPlace.m_61124_((Property)FACING, (Comparable)d);
            if (context.m_43719_() == d.m_122424_()) break;
        }
        return toPlace;
    }

    public static boolean isPump(BlockState state) {
        return state.m_60734_() instanceof PumpBlock;
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
        if (PumpBlock.isPump(state) && PumpBlock.isPump(oldState) && state.m_61143_((Property)FACING) == ((Direction)oldState.m_61143_((Property)FACING)).m_122424_()) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (!(tileEntity instanceof PumpTileEntity)) {
                return;
            }
            PumpTileEntity pump = (PumpTileEntity)tileEntity;
            pump.pressureUpdate = true;
        }
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.m_60734_() != newState.m_60734_();
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        if (state.m_155947_() && (blockTypeChanged || !newState.m_155947_())) {
            world.m_46747_(pos);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<PumpTileEntity> getTileEntityClass() {
        return PumpTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends PumpTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.MECHANICAL_PUMP.get();
    }
}

