/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.itemAssembly;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SequencedAssemblyRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<SequencedAssemblyRecipe> {
    protected void writeToJson(JsonObject json, SequencedAssemblyRecipe recipe) {
        JsonArray nestedRecipes = new JsonArray();
        JsonArray results = new JsonArray();
        json.add("ingredient", recipe.getIngredient().m_43942_());
        recipe.getSequence().forEach(i -> nestedRecipes.add((JsonElement)i.toJson()));
        recipe.resultPool.forEach(p -> results.add(p.serialize()));
        json.add("transitionalItem", recipe.transitionalItem.serialize());
        json.add("sequence", (JsonElement)nestedRecipes);
        json.add("results", (JsonElement)results);
        json.addProperty("loops", (Number)recipe.loops);
    }

    protected SequencedAssemblyRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        SequencedAssemblyRecipe recipe = new SequencedAssemblyRecipe(recipeId, this);
        recipe.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
        recipe.transitionalItem = ProcessingOutput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"transitionalItem"));
        int i = 0;
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"sequence")) {
            recipe.getSequence().add(SequencedRecipe.fromJson(je.getAsJsonObject(), recipe, i++));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"results")) {
            recipe.resultPool.add(ProcessingOutput.deserialize(je));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"loops")) {
            recipe.loops = GsonHelper.m_13927_((JsonObject)json, (String)"loops");
        }
        return recipe;
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, SequencedAssemblyRecipe recipe) {
        recipe.getIngredient().m_43923_(buffer);
        buffer.m_130130_(recipe.getSequence().size());
        recipe.getSequence().forEach(sr -> sr.writeToBuffer(buffer));
        buffer.m_130130_(recipe.resultPool.size());
        recipe.resultPool.forEach(sr -> sr.write(buffer));
        recipe.transitionalItem.write(buffer);
        buffer.writeInt(recipe.loops);
    }

    protected SequencedAssemblyRecipe readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        SequencedAssemblyRecipe recipe = new SequencedAssemblyRecipe(recipeId, this);
        recipe.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            recipe.getSequence().add(SequencedRecipe.readFromBuffer(buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            recipe.resultPool.add(ProcessingOutput.read(buffer));
        }
        recipe.transitionalItem = ProcessingOutput.read(buffer);
        recipe.loops = buffer.readInt();
        return recipe;
    }

    public final void write(JsonObject json, SequencedAssemblyRecipe recipe) {
        this.writeToJson(json, recipe);
    }

    public final SequencedAssemblyRecipe fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(FriendlyByteBuf buffer, SequencedAssemblyRecipe recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final SequencedAssemblyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        return this.readFromBuffer(id, buffer);
    }
}

