/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.foundation.block.render.QuadHelper;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;

public class BeltModel
extends BakedModelWrapper<BakedModel> {
    private static final SpriteShiftEntry SPRITE_SHIFT = AllSpriteShifts.ANDESIDE_BELT_CASING;

    public BeltModel(BakedModel template) {
        super(template);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (!extraData.hasProperty(BeltTileEntity.CASING_PROPERTY)) {
            return quads;
        }
        BeltTileEntity.CasingType type = (BeltTileEntity.CasingType)((Object)extraData.getData(BeltTileEntity.CASING_PROPERTY));
        if (type == BeltTileEntity.CasingType.NONE || type == BeltTileEntity.CasingType.BRASS) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            TextureAtlasSprite original = quad.m_173410_();
            if (original != SPRITE_SHIFT.getOriginal()) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, SPRITE_SHIFT.getTargetU(u));
                QuadHelper.setV(vertexData, vertex, SPRITE_SHIFT.getTargetV(v));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

