/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.EjectorAwardPacket;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorElytraPacket;
import com.simibubi.create.content.logistics.block.depot.EntityLauncher;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class EjectorTileEntity
extends KineticTileEntity {
    List<IntAttached<ItemStack>> launchedItems;
    ScrollValueBehaviour maxStackSize;
    DepotBehaviour depotBehaviour;
    EntityLauncher launcher = new EntityLauncher(1, 0);
    LerpedFloat lidProgress = LerpedFloat.linear().startWithValue(1.0);
    boolean powered = false;
    boolean launch;
    State state = State.RETRACTING;
    @Nullable
    Pair<Vec3, BlockPos> earlyTarget;
    float earlyTargetTime;
    int scanCooldown;
    ItemStack trackedItem;

    public EjectorTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.launchedItems = new ArrayList<IntAttached<ItemStack>>();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.depotBehaviour = new DepotBehaviour(this);
        behaviours.add(this.depotBehaviour);
        this.maxStackSize = new ScrollValueBehaviour((Component)Lang.translateDirect("weighted_ejector.stack_size", new Object[0]), this, new EjectorSlot()).between(0, 64).withFormatter(i -> i == 0 ? "*" : String.valueOf(i)).onlyActiveWhen(() -> this.state == State.CHARGED).requiresWrench();
        behaviours.add(this.maxStackSize);
        this.depotBehaviour.maxStackSize = () -> this.maxStackSize.getValue();
        this.depotBehaviour.canAcceptItems = () -> this.state == State.CHARGED;
        this.depotBehaviour.canFunnelsPullFrom = side -> side != this.getFacing();
        this.depotBehaviour.enableMerging();
        this.depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignal();
    }

    public void activate() {
        this.launch = true;
        this.nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return this.state != State.CHARGED && (!this.f_58857_.f_46443_ || this.state != State.LAUNCHING);
    }

    public void activateDeferred() {
        boolean doLogic;
        if (this.cannotLaunch()) {
            return;
        }
        Direction facing = this.getFacing();
        List entities = this.f_58857_.m_45976_(Entity.class, new AABB(this.f_58858_).m_82377_(-0.0625, 0.0, -0.0625));
        boolean bl = doLogic = !this.f_58857_.f_46443_ || this.isVirtual();
        if (doLogic) {
            this.launchItems();
        }
        for (Entity entity : entities) {
            boolean isPlayerEntity = entity instanceof Player;
            if (!entity.m_6084_() || entity instanceof ItemEntity || entity.m_7752_() == PushReaction.IGNORE) continue;
            entity.m_6853_(false);
            if (isPlayerEntity != this.f_58857_.f_46443_) continue;
            entity.m_6034_((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)(this.f_58858_.m_123342_() + 1), (double)((float)this.f_58858_.m_123343_() + 0.5f));
            this.launcher.applyMotion(entity, facing);
            if (!isPlayerEntity) continue;
            Player playerEntity = (Player)entity;
            if (this.launcher.getHorizontalDistance() * this.launcher.getHorizontalDistance() + this.launcher.getVerticalDistance() * this.launcher.getVerticalDistance() >= 625) {
                AllPackets.channel.sendToServer((Object)new EjectorAwardPacket(this.f_58858_));
            }
            if (!(playerEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem)) continue;
            playerEntity.m_146926_(-35.0f);
            playerEntity.m_146922_(facing.m_122435_());
            playerEntity.m_20256_(playerEntity.m_20184_().m_82490_(0.75));
            this.deployElytra(playerEntity);
            AllPackets.channel.sendToServer((Object)new EjectorElytraPacket(this.f_58858_));
        }
        if (doLogic) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.state = State.LAUNCHING;
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12628_, SoundSource.BLOCKS, 0.35f, 1.0f);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.1f, 1.4f);
            }
        }
    }

    public void deployElytra(Player playerEntity) {
        EntityHack.setElytraFlying((Entity)playerEntity);
    }

    protected void launchItems() {
        ItemStack heldItemStack = this.depotBehaviour.getHeldItemStack();
        Direction funnelFacing = this.getFacing().m_122424_();
        if (AbstractFunnelBlock.getFunnelFacing(this.f_58857_.m_8055_(this.f_58858_.m_7494_())) == funnelFacing) {
            ItemStack remainder;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (this.depotBehaviour.heldItem != null && (remainder = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false)) != null) {
                if (remainder.m_41619_()) {
                    this.depotBehaviour.removeHeldItem();
                } else if (!remainder.m_41656_(heldItemStack)) {
                    this.depotBehaviour.heldItem.stack = remainder;
                }
            }
            Iterator<TransportedItemStack> iterator = this.depotBehaviour.incoming.iterator();
            while (iterator.hasNext()) {
                TransportedItemStack transportedItemStack = iterator.next();
                ItemStack stack = transportedItemStack.stack;
                ItemStack remainder2 = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder2 == null) continue;
                if (remainder2.m_41619_()) {
                    iterator.remove();
                    continue;
                }
                if (remainder2.m_41656_(stack)) continue;
                transportedItemStack.stack = remainder2;
            }
            ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
            for (int i = 0; i < outputs.getSlots(); ++i) {
                ItemStack remainder3 = directOutput.tryExportingToBeltFunnel(outputs.getStackInSlot(i), funnelFacing, false);
                if (remainder3 == null) continue;
                outputs.setStackInSlot(i, remainder3);
            }
            return;
        }
        if (!this.f_58857_.f_46443_) {
            for (Direction d : Iterate.directions) {
                BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_142300_(d));
                if (!(blockState.m_60734_() instanceof ObserverBlock) || blockState.m_61143_((Property)ObserverBlock.f_52588_) != d.m_122424_()) continue;
                blockState.m_60728_(d.m_122424_(), blockState, (LevelAccessor)this.f_58857_, this.f_58858_.m_142300_(d), this.f_58858_);
            }
        }
        if (this.depotBehaviour.heldItem != null) {
            this.addToLaunchedItems(heldItemStack);
            this.depotBehaviour.removeHeldItem();
        }
        for (TransportedItemStack transportedItemStack : this.depotBehaviour.incoming) {
            this.addToLaunchedItems(transportedItemStack.stack);
        }
        this.depotBehaviour.incoming.clear();
        ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
        for (int i = 0; i < outputs.getSlots(); ++i) {
            ItemStack extractItem = outputs.extractItem(i, 64, false);
            if (extractItem.m_41619_()) continue;
            this.addToLaunchedItems(extractItem);
        }
    }

    protected boolean addToLaunchedItems(ItemStack stack) {
        if ((!this.f_58857_.f_46443_ || this.isVirtual()) && this.trackedItem == null && this.scanCooldown == 0) {
            this.scanCooldown = (Integer)AllConfigs.SERVER.kinetics.ejectorScanInterval.get();
            this.trackedItem = stack;
        }
        return this.launchedItems.add(IntAttached.withZero(stack));
    }

    protected Direction getFacing() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return Direction.UP;
        }
        Direction facing = (Direction)blockState.m_61143_(EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void tick() {
        super.tick();
        boolean doLogic = !this.f_58857_.f_46443_ || this.isVirtual();
        State prevState = this.state;
        float totalTime = Math.max(3.0f, (float)this.launcher.getTotalFlyingTicks());
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.launch) {
            this.launch = false;
            this.activateDeferred();
        }
        Iterator<IntAttached<ItemStack>> iterator = this.launchedItems.iterator();
        while (iterator.hasNext()) {
            float maxTime;
            IntAttached<ItemStack> intAttached = iterator.next();
            boolean hit = false;
            if (intAttached.getSecond() == this.trackedItem) {
                hit = this.scanTrajectoryForObstacles((Integer)intAttached.getFirst());
            }
            float f = maxTime = this.earlyTarget != null ? Math.min(this.earlyTargetTime, totalTime) : totalTime;
            if (hit || intAttached.exceeds((int)maxTime)) {
                this.placeItemAtTarget(doLogic, maxTime, intAttached);
                iterator.remove();
            }
            intAttached.increment();
        }
        if (this.state == State.LAUNCHING) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.lidProgress.tickChaser();
            if (this.lidProgress.getValue() > 0.9375f && doLogic) {
                this.state = State.RETRACTING;
                this.lidProgress.setValue(1.0);
            }
        }
        if (this.state == State.CHARGED) {
            this.lidProgress.setValue(0.0);
            this.lidProgress.updateChaseSpeed(0.0);
            if (doLogic) {
                this.ejectIfTriggered();
            }
        }
        if (this.state == State.RETRACTING) {
            if (this.lidProgress.getChaseTarget() == 1.0f && !this.lidProgress.settled()) {
                this.lidProgress.tickChaser();
            } else {
                this.lidProgress.updateChaseTarget(0.0f);
                this.lidProgress.updateChaseSpeed(0.0);
                if (this.lidProgress.getValue() == 0.0f && doLogic) {
                    this.state = State.CHARGED;
                    this.lidProgress.setValue(0.0);
                    this.sendData();
                }
                float value = Mth.m_14036_((float)(this.lidProgress.getValue() - this.getWindUpSpeed()), (float)0.0f, (float)1.0f);
                this.lidProgress.setValue(value);
                int soundRate = (int)(1.0f / (this.getWindUpSpeed() * 5.0f)) + 1;
                float volume = 0.125f;
                float pitch = 1.5f - this.lidProgress.getValue();
                if ((int)this.f_58857_.m_46467_() % soundRate == 0 && doLogic) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12631_, SoundSource.BLOCKS, volume, pitch);
                }
            }
        }
        if (this.state != prevState) {
            this.notifyUpdate();
        }
    }

    private boolean scanTrajectoryForObstacles(int time) {
        BlockState blockState;
        boolean miss;
        Vec3 target;
        if (time <= 2) {
            return false;
        }
        Vec3 source = this.getLaunchedItemLocation(time);
        BlockHitResult rayTraceBlocks = this.f_58857_.m_45547_(new ClipContext(source, target = this.getLaunchedItemLocation(time + 1), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        boolean bl = miss = rayTraceBlocks.m_6662_() == HitResult.Type.MISS;
        if (!miss && rayTraceBlocks.m_6662_() == HitResult.Type.BLOCK && FunnelBlock.isFunnel(blockState = this.f_58857_.m_8055_(rayTraceBlocks.m_82425_())) && blockState.m_61138_((Property)FunnelBlock.EXTRACTING) && ((Boolean)blockState.m_61143_((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < (float)(time + 1)) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        Vec3 vec = rayTraceBlocks.m_82450_();
        this.earlyTarget = Pair.of(vec.m_82549_(Vec3.m_82528_((Vec3i)rayTraceBlocks.m_82434_().m_122436_()).m_82490_(0.25)), rayTraceBlocks.m_82425_());
        this.earlyTargetTime = (float)((double)time + source.m_82554_(vec) / source.m_82554_(target));
        this.sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (Entity entity : this.f_58857_.m_45976_(Entity.class, new AABB(this.f_58858_).m_82377_(-0.0625, 0.0, -0.0625))) {
            if (!entity.m_6084_() || entity.m_7752_() == PushReaction.IGNORE || entity instanceof Player) continue;
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 0.125, entity.m_20189_());
        }
    }

    protected void ejectIfTriggered() {
        DirectBeltInputBehaviour targetOpenInv;
        if (this.powered) {
            return;
        }
        int presentStackSize = this.depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0) {
            return;
        }
        if (presentStackSize < this.maxStackSize.getValue()) {
            return;
        }
        if (this.depotBehaviour.heldItem != null && this.depotBehaviour.heldItem.beltPosition < 0.49f) {
            return;
        }
        Direction funnelFacing = this.getFacing().m_122424_();
        ItemStack held = this.depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(this.f_58857_.m_8055_(this.f_58858_.m_7494_())) == funnelFacing) {
            ItemStack tryFunnel;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (!(this.depotBehaviour.heldItem == null || (tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true)) != null && tryFunnel.m_41619_())) {
                return;
            }
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null && this.depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, Direction.UP, true).m_41613_() == held.m_41613_()) {
            return;
        }
        this.activate();
        this.notifyUpdate();
    }

    protected void placeItemAtTarget(boolean doLogic, float maxTime, IntAttached<ItemStack> intAttached) {
        DirectBeltInputBehaviour targetOpenInv;
        if (!doLogic) {
            return;
        }
        if (intAttached.getSecond() == this.trackedItem) {
            this.trackedItem = null;
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null) {
            ItemStack remainder = targetOpenInv.handleInsertion(intAttached.getValue(), Direction.UP, false);
            intAttached.setSecond(remainder);
        }
        if (intAttached.getValue().m_41619_()) {
            return;
        }
        Vec3 ejectVec = this.earlyTarget != null ? this.earlyTarget.getFirst() : this.getLaunchedItemLocation(maxTime);
        Vec3 ejectMotionVec = this.getLaunchedItemMotion(maxTime);
        ItemEntity item = new ItemEntity(this.f_58857_, ejectVec.f_82479_, ejectVec.f_82480_, ejectVec.f_82481_, intAttached.getValue());
        item.m_20256_(ejectMotionVec);
        item.m_32060_();
        this.f_58857_.m_7967_((Entity)item);
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        BlockPos targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.f_58858_.m_6630_(this.launcher.getVerticalDistance()).m_5484_(this.getFacing(), Math.max(1, this.launcher.getHorizontalDistance()));
        return TileEntityBehaviour.get((BlockGetter)this.f_58857_, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public Vec3 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos(time, this.getFacing().m_122424_(), this.f_58858_);
    }

    public Vec3 getLaunchedItemMotion(float time) {
        return this.launcher.getGlobalVelocity(time, this.getFacing().m_122424_(), this.f_58858_).m_82490_(0.5);
    }

    public void dropFlyingItems() {
        for (IntAttached<ItemStack> intAttached : this.launchedItems) {
            Vec3 ejectVec = this.getLaunchedItemLocation(((Integer)intAttached.getFirst()).intValue());
            Vec3 ejectMotionVec = this.getLaunchedItemMotion(((Integer)intAttached.getFirst()).intValue());
            ItemEntity item = new ItemEntity(this.f_58857_, 0.0, 0.0, 0.0, intAttached.getValue());
            item.m_20343_(ejectVec.f_82479_, ejectVec.f_82480_, ejectVec.f_82481_);
            item.m_20256_(ejectMotionVec);
            item.m_32060_();
            this.f_58857_.m_7967_((Entity)item);
        }
        this.launchedItems.clear();
    }

    public float getWindUpSpeed() {
        int hd = this.launcher.getHorizontalDistance();
        int vd = this.launcher.getVerticalDistance();
        float speedFactor = Math.abs(this.getSpeed()) / 256.0f;
        float distanceFactor = hd == 0 && vd == 0 ? 1.0f : 1.0f * Mth.m_14116_((float)(hd * hd + vd * vd));
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("HorizontalDistance", this.launcher.getHorizontalDistance());
        compound.m_128405_("VerticalDistance", this.launcher.getVerticalDistance());
        compound.m_128379_("Powered", this.powered);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.m_128365_("Lid", (Tag)this.lidProgress.writeNBT());
        compound.m_128365_("LaunchedItems", (Tag)NBTHelper.writeCompoundList(this.launchedItems, ia -> ia.serializeNBT(IForgeItemStack::serializeNBT)));
        if (this.earlyTarget != null) {
            compound.m_128365_("EarlyTarget", (Tag)VecHelper.writeNBT(this.earlyTarget.getFirst()));
            compound.m_128365_("EarlyTargetPos", (Tag)NbtUtils.m_129224_((BlockPos)this.earlyTarget.getSecond()));
            compound.m_128350_("EarlyTargetTime", this.earlyTargetTime);
        }
    }

    @Override
    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        compound.m_128405_("HorizontalDistance", this.launcher.getHorizontalDistance());
        compound.m_128405_("VerticalDistance", this.launcher.getVerticalDistance());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        int horizontalDistance = compound.m_128451_("HorizontalDistance");
        int verticalDistance = compound.m_128451_("VerticalDistance");
        if (this.launcher.getHorizontalDistance() != horizontalDistance || this.launcher.getVerticalDistance() != verticalDistance) {
            this.launcher.set(horizontalDistance, verticalDistance);
            this.launcher.clamp((Integer)AllConfigs.SERVER.kinetics.maxEjectorDistance.get());
        }
        this.powered = compound.m_128471_("Powered");
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.lidProgress.readNBT(compound.m_128469_("Lid"), false);
        this.launchedItems = NBTHelper.readCompoundList(compound.m_128437_("LaunchedItems", 10), nbt -> IntAttached.read(nbt, ItemStack::m_41712_));
        this.earlyTarget = null;
        this.earlyTargetTime = 0.0f;
        if (compound.m_128441_("EarlyTarget")) {
            this.earlyTarget = Pair.of(VecHelper.readNBT(compound.m_128437_("EarlyTarget", 6)), NbtUtils.m_129239_((CompoundTag)compound.m_128469_("EarlyTargetPos")));
            this.earlyTargetTime = compound.m_128457_("EarlyTargetTime");
        }
        if (compound.m_128441_("ForceAngle")) {
            this.lidProgress.startWithValue(compound.m_128457_("ForceAngle"));
        }
    }

    public void updateSignal() {
        boolean shoudPower = this.f_58857_.m_46753_(this.f_58858_);
        if (shoudPower == this.powered) {
            return;
        }
        this.powered = shoudPower;
        this.sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        this.launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        this.sendData();
    }

    public BlockPos getTargetPosition() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return this.f_58858_;
        }
        Direction facing = (Direction)blockState.m_61143_(EjectorBlock.HORIZONTAL_FACING);
        return this.f_58858_.m_5484_(facing, this.launcher.getHorizontalDistance()).m_6630_(this.launcher.getVerticalDistance());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.depotBehaviour.getItemCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public float getLidProgress(float pt) {
        return this.lidProgress.getValue(pt);
    }

    public State getState() {
        return this.state;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static enum State {
        CHARGED,
        LAUNCHING,
        RETRACTING;

    }

    private static class EjectorSlot
    extends ValueBoxTransform.Sided {
        private EjectorSlot() {
        }

        @Override
        protected Vec3 getLocalOffset(BlockState state) {
            return new Vec3(0.5, 0.8125, 0.5).m_82549_(VecHelper.rotate(new Vec3(0.0, 0.0, -0.3), this.angle(state), Direction.Axis.Y));
        }

        @Override
        protected void rotate(BlockState state, PoseStack ms) {
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)this.angle(state))).rotateX(90.0);
        }

        protected float angle(BlockState state) {
            float horizontalAngle = AllBlocks.WEIGHTED_EJECTOR.has(state) ? AngleHelper.horizontalAngle((Direction)state.m_61143_(EjectorBlock.HORIZONTAL_FACING)) : 0.0f;
            return horizontalAngle;
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }

        @Override
        protected float getScale() {
            return 0.2f;
        }

        @Override
        protected Vec3 getSouthLocation() {
            return Vec3.f_82478_;
        }
    }

    private static abstract class EntityHack
    extends Entity {
        public EntityHack(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(Entity e) {
            SynchedEntityData data = e.m_20088_();
            data.m_135381_(f_19805_, (Object)((byte)((Byte)data.m_135370_(f_19805_) | 0x80)));
        }
    }
}

