/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.clock.CuckooClockTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.SingleLineDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimeOfDayDisplaySource
extends SingleLineDisplaySource {
    public static final MutableComponent EMPTY_TIME = Components.literal("--:--");

    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        Level level = context.level();
        if (!(level instanceof ServerLevel)) {
            return EMPTY_TIME;
        }
        ServerLevel sLevel = (ServerLevel)level;
        BlockEntity blockEntity = context.getSourceTE();
        if (!(blockEntity instanceof CuckooClockTileEntity)) {
            return EMPTY_TIME;
        }
        CuckooClockTileEntity ccte = (CuckooClockTileEntity)blockEntity;
        if (ccte.getSpeed() == 0.0f) {
            return EMPTY_TIME;
        }
        boolean c12 = context.sourceConfig().m_128451_("Cycle") == 0;
        boolean isNatural = sLevel.m_6042_().m_63956_();
        int dayTime = (int)(sLevel.m_46468_() % 24000L);
        int hours = (dayTime / 1000 + 6) % 24;
        int minutes = dayTime % 1000 * 60 / 1000;
        MutableComponent suffix = Lang.translateDirect("generic.daytime." + (hours > 11 ? "pm" : "am"), new Object[0]);
        minutes = minutes / 5 * 5;
        if (c12 && (hours %= 12) == 0) {
            hours = 12;
        }
        if (!isNatural) {
            hours = Create.RANDOM.nextInt(70) + 24;
            minutes = Create.RANDOM.nextInt(40) + 60;
        }
        MutableComponent component = Components.literal((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : ""));
        return c12 ? component.m_7220_((Component)suffix) : component;
    }

    @Override
    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Instant";
    }

    @Override
    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
    }

    @Override
    protected String getTranslationKey() {
        return "time_of_day";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 60, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.time", "12_hour", "24_hour")).titled(Lang.translateDirect("display_source.time.format", new Object[0])), "Cycle");
    }

    @Override
    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

