/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFilterScreen<F extends AbstractFilterContainer>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F container, Inventory inv, Component title, AllGuiTextures background) {
        super(container, inv, title);
        this.background = background;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(Math.max(this.background.width, AllGuiTextures.PLAYER_INVENTORY.width), this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.resetButton = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((AbstractFilterContainer)this.f_97732_).clearContents();
            this.contentsCleared();
            ((AbstractFilterContainer)this.f_97732_).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_(this.resetButton);
        this.m_142416_(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 40, 80, 48));
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(ms, x, y, (GuiComponent)this);
        AbstractFilterScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)this.f_96539_, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((AbstractFilterContainer)this.f_97732_).contentHolder).at(x + this.background.width, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    @Override
    protected void m_181908_() {
        if (!((AbstractFilterContainer)this.f_97732_).player.m_21205_().equals((ItemStack)((AbstractFilterContainer)this.f_97732_).contentHolder, false)) {
            ((AbstractFilterContainer)this.f_97732_).player.m_6915_();
        }
        super.m_181908_();
        this.handleTooltips();
        this.handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((Component)TooltipHelper.holdShift(ItemDescription.Palette.Yellow, AbstractFilterScreen.m_96638_()));
        }
        if (AbstractFilterScreen.m_96638_()) {
            List<MutableComponent> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (Component)tooltipDescriptions.get(i));
            }
        }
    }

    public void handleIndicators() {
        for (IconButton button : this.getTooltipButtons()) {
            button.f_93623_ = this.isButtonEnabled(button);
        }
        for (Indicator indicator : this.getIndicators()) {
            indicator.state = this.isIndicatorOn(indicator) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<MutableComponent> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    protected List<Indicator> getIndicators() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, Component tooltip) {
        if (!button.m_198029_()) {
            return;
        }
        List<Component> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, ChatFormatting.GRAY, ChatFormatting.GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.channel.sendToServer((Object)new FilterScreenPacket(option));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

